/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.impl.ComponentManagerSettingsImpl;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleSettingsImpl
extends ComponentManagerSettingsImpl
implements ModuleSettings {
    private final String myModuleName;
    @NonNls
    private static final String MODULE_ROOT_MANAGER_COMPONENT = "NewModuleRootManager";

    public ModuleSettingsImpl(File moduleFile, ConversionContextImpl context) throws CannotConvertException {
        super(moduleFile, context);
        this.myModuleName = StringUtil.trimEnd((String)moduleFile.getName(), (String)".iml");
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ModuleSettingsImpl.getModuleName must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    public String getModuleType() {
        return this.getRootElement().getAttributeValue("type");
    }

    @Override
    @NotNull
    public File getModuleFile() {
        File file = this.mySettingsFile.getFile();
        if (file == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ModuleSettingsImpl.getModuleFile must not return null");
        }
        return file;
    }

    @Override
    @NotNull
    public Collection<? extends Element> getFacetElements(@NotNull String facetTypeId) {
        if (facetTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ModuleSettingsImpl.getFacetElements must not be null");
        }
        Element facetManager = this.getComponentElement("FacetManager");
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element child : JDomConvertingUtil.getChildren(facetManager, "facet")) {
            if (!facetTypeId.equals(child.getAttributeValue("type"))) continue;
            elements.add(child);
        }
        ArrayList<Element> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ModuleSettingsImpl.getFacetElements must not return null");
        }
        return arrayList;
    }

    @Override
    public Element getFacetElement(@NotNull String facetTypeId) {
        if (facetTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ModuleSettingsImpl.getFacetElement must not be null");
        }
        return (Element)ContainerUtil.getFirstItem(this.getFacetElements(facetTypeId), null);
    }

    @Override
    public void setModuleType(@NotNull String moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ModuleSettingsImpl.setModuleType must not be null");
        }
        this.getRootElement().setAttribute("type", moduleType);
    }

    @Override
    @NotNull
    public String expandPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ModuleSettingsImpl.expandPath must not be null");
        }
        String string = this.myContext.expandPath(path, this);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ModuleSettingsImpl.expandPath must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<File> getSourceRoots(boolean includeTests) {
        ArrayList<File> result = new ArrayList<File>();
        for (Element contentRoot : this.getContentRootElements()) {
            for (Element sourceFolder : JDomConvertingUtil.getChildren(contentRoot, "sourceFolder")) {
                boolean isTestFolder = Boolean.parseBoolean(sourceFolder.getAttributeValue("isTestSource"));
                if (!includeTests && isTestFolder) continue;
                result.add(this.getFile(sourceFolder.getAttributeValue("url")));
            }
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ModuleSettingsImpl.getSourceRoots must not return null");
        }
        return arrayList;
    }

    private List<Element> getContentRootElements() {
        return JDomConvertingUtil.getChildren(this.getComponentElement(MODULE_ROOT_MANAGER_COMPONENT), "content");
    }

    @Override
    @NotNull
    public Collection<File> getContentRoots() {
        ArrayList<File> result = new ArrayList<File>();
        for (Element contentRoot : this.getContentRootElements()) {
            String path = VfsUtil.urlToPath((String)contentRoot.getAttributeValue("url"));
            result.add(new File(FileUtil.toSystemDependentName((String)this.expandPath(path))));
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ModuleSettingsImpl.getContentRoots must not return null");
        }
        return arrayList;
    }

    @Override
    public void addExcludedFolder(@NotNull File directory) {
        String outputUrl;
        Element outputElement;
        Element projectRootManager;
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ModuleSettingsImpl.addExcludedFolder must not be null");
        }
        ComponentManagerSettings rootManagerSettings = this.myContext.getProjectRootManagerSettings();
        if (rootManagerSettings != null && (projectRootManager = rootManagerSettings.getComponentElement("ProjectRootManager")) != null && (outputElement = projectRootManager.getChild("output")) != null && (outputUrl = outputElement.getAttributeValue("url")) != null) {
            File outputFile = this.getFile(outputUrl);
            try {
                if (FileUtil.isAncestor((File)outputFile, (File)directory, (boolean)false)) {
                    return;
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        for (Element contentRoot : this.getContentRootElements()) {
            File root = this.getFile(contentRoot.getAttributeValue("url"));
            try {
                if (!FileUtil.isAncestor((File)root, (File)directory, (boolean)true)) continue;
                this.addExcludedFolder(directory, contentRoot);
            }
            catch (IOException ignored) {}
        }
    }

    @Override
    @NotNull
    public List<File> getModuleLibraryRoots(String libraryName) {
        Element library = this.findModuleLibraryElement(libraryName);
        List<File> list = library != null ? this.myContext.getClassRoots(library, this) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ModuleSettingsImpl.getModuleLibraryRoots must not return null");
        }
        return list;
    }

    @Override
    public boolean hasModuleLibrary(String libraryName) {
        return this.findModuleLibraryElement(libraryName) != null;
    }

    @Nullable
    private Element findModuleLibraryElement(String libraryName) {
        for (Element element : this.getOrderEntries()) {
            Element library;
            if (!"module-library".equals(element.getAttributeValue("type")) || (library = element.getChild("library")) == null || !libraryName.equals(library.getAttributeValue("name"))) continue;
            return library;
        }
        return null;
    }

    private List<Element> getOrderEntries() {
        Element component = this.getComponentElement(MODULE_ROOT_MANAGER_COMPONENT);
        return JDomConvertingUtil.getChildren(component, "orderEntry");
    }

    @Override
    @NotNull
    public Collection<ModuleSettings> getAllModuleDependencies() {
        HashSet<ModuleSettings> dependencies = new HashSet<ModuleSettings>();
        this.collectDependencies(dependencies);
        HashSet<ModuleSettings> hashSet = dependencies;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ModuleSettingsImpl.getAllModuleDependencies must not return null");
        }
        return hashSet;
    }

    private void collectDependencies(Set<ModuleSettings> dependencies) {
        if (!dependencies.add(this)) {
            return;
        }
        for (Element element : this.getOrderEntries()) {
            ModuleSettings moduleSettings;
            String moduleName;
            if (!"module".equals(element.getAttributeValue("type")) || (moduleName = element.getAttributeValue("module-name")) == null || (moduleSettings = this.myContext.getModuleSettings(moduleName)) == null) continue;
            ((ModuleSettingsImpl)moduleSettings).collectDependencies(dependencies);
        }
    }

    private void addExcludedFolder(File directory, Element contentRoot) throws IOException {
        for (Element excludedFolder : JDomConvertingUtil.getChildren(contentRoot, "excludeFolder")) {
            File excludedDir = this.getFile(excludedFolder.getAttributeValue("url"));
            if (!FileUtil.isAncestor((File)excludedDir, (File)directory, (boolean)false)) continue;
            return;
        }
        String path = this.myContext.collapsePath(FileUtil.toSystemIndependentName((String)directory.getAbsolutePath()), this);
        contentRoot.addContent(new Element("excludeFolder").setAttribute("url", VfsUtil.pathToUrl((String)path)));
    }

    private File getFile(String url) {
        return new File(FileUtil.toSystemDependentName((String)this.expandPath(VfsUtil.urlToPath((String)url))));
    }
}

