/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class TypeExpression
extends Expression {
    private final Set<SmartTypePointer> myItems;

    public TypeExpression(Project project, PsiType[] types) {
        SmartTypePointerManager manager = SmartTypePointerManager.getInstance((Project)project);
        this.myItems = new LinkedHashSet<SmartTypePointer>();
        for (PsiType type : types) {
            this.myItems.add(manager.createSmartTypePointer(type));
        }
    }

    public Result calculateResult(ExpressionContext context) {
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (this.myItems.isEmpty()) {
            return null;
        }
        PsiType type = this.myItems.iterator().next().getType();
        return type == null ? null : new PsiTypeResult(type, project);
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        if (this.myItems.size() <= 1) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        ArrayList<LookupItem> result = new ArrayList<LookupItem>(this.myItems.size());
        for (SmartTypePointer item : this.myItems) {
            PsiType type = item.getType();
            if (type == null) continue;
            result.add(PsiTypeLookupItem.createLookupItem(type, null));
        }
        return result.toArray(new LookupElement[result.size()]);
    }
}

