/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class JavaLineMarkerProvider
implements LineMarkerProvider,
DumbAware {
    private static final Icon OVERRIDING_METHOD_ICON = IconLoader.getIcon((String)"/gutter/overridingMethod.png");
    private static final Icon IMPLEMENTING_METHOD_ICON = IconLoader.getIcon((String)"/gutter/implementingMethod.png");
    private static final Icon OVERRIDEN_METHOD_MARKER_RENDERER = IconLoader.getIcon((String)"/gutter/overridenMethod.png");
    private static final Icon IMPLEMENTED_METHOD_MARKER_RENDERER;
    private static final Icon IMPLEMENTED_INTERFACE_MARKER_RENDERER;
    private static final Icon SUBCLASSED_CLASS_MARKER_RENDERER;
    protected final DaemonCodeAnalyzerSettings myDaemonSettings;
    protected final EditorColorsManager myColorsManager;

    public JavaLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(PsiElement element) {
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element.getParent();
            MethodSignatureBackedByPsiMethod superSignature = null;
            try {
                superSignature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            }
            catch (IndexNotReadyException e) {
                // empty catch block
            }
            if (superSignature != null) {
                boolean overrides = method.hasModifierProperty("abstract") == superSignature.getMethod().hasModifierProperty("abstract");
                Icon icon = overrides ? OVERRIDING_METHOD_ICON : IMPLEMENTING_METHOD_ICON;
                MarkerType type = MarkerType.OVERRIDING_METHOD;
                return new LineMarkerInfo(element, element.getTextRange(), icon, 4, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
            }
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && element.getFirstChild() == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!((element1 = element1.getParent()) instanceof PsiMember)) continue;
                isMember = true;
                break;
            }
            if (isMember && !(element1 instanceof PsiAnonymousClass) && !(element1.getParent() instanceof PsiAnonymousClass)) {
                boolean drawSeparator = false;
                int category = JavaLineMarkerProvider.getCategory(element1);
                for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                    int category1 = JavaLineMarkerProvider.getCategory(child);
                    if (category1 == 0) continue;
                    drawSeparator = category != 1 || category1 != 1;
                    break;
                }
                if (drawSeparator) {
                    LineMarkerInfo info = new LineMarkerInfo(element, element.getTextRange(), null, 4, (Function)NullableFunction.NULL, null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme = this.myColorsManager.getGlobalScheme();
                    info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        return null;
    }

    protected static int getCategory(PsiElement element) {
        if (element instanceof PsiField) {
            return 1;
        }
        if (element instanceof PsiClass || element instanceof PsiClassInitializer) {
            return 2;
        }
        if (element instanceof PsiMethod) {
            if (((PsiMethod)element).hasModifierProperty("abstract")) {
                return 1;
            }
            String text = element.getText();
            if (text.indexOf(10) < 0 && text.indexOf(13) < 0) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public void collectSlowLineMarkers(List<PsiElement> elements, Collection<LineMarkerInfo> result) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (elements.isEmpty() || DumbService.getInstance((Project)elements.get(0).getProject()).isDumb()) {
            return;
        }
        HashSet methods = new HashSet();
        for (PsiElement element : elements) {
            ProgressManager.checkCanceled();
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                if (!PsiUtil.canBeOverriden((PsiMethod)method)) continue;
                methods.add(method);
                continue;
            }
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            JavaLineMarkerProvider.collectInheritingClasses((PsiClass)element, result);
        }
        if (!methods.isEmpty()) {
            JavaLineMarkerProvider.collectOverridingMethods((Set<PsiMethod>)methods, result);
        }
    }

    private static void collectInheritingClasses(PsiClass aClass, Collection<LineMarkerInfo> result) {
        if (!aClass.hasModifierProperty("final")) {
            if ("java.lang.Object".equals(aClass.getQualifiedName())) {
                return;
            }
            PsiClass inheritor = (PsiClass)ClassInheritorsSearch.search((PsiClass)aClass, (boolean)false).findFirst();
            if (inheritor != null) {
                Icon icon = aClass.isInterface() ? IMPLEMENTED_INTERFACE_MARKER_RENDERER : SUBCLASSED_CLASS_MARKER_RENDERER;
                MarkerType type = MarkerType.SUBCLASSED_CLASS;
                PsiIdentifier range = aClass.getNameIdentifier();
                if (range == null) {
                    range = aClass;
                }
                LineMarkerInfo info = new LineMarkerInfo((PsiElement)range, range.getTextRange(), icon, 6, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
                result.add(info);
            }
        }
    }

    private static void collectOverridingMethods(final Set<PsiMethod> methods, Collection<LineMarkerInfo> result) {
        HashSet overridden = new HashSet();
        THashSet classes = new THashSet();
        for (PsiMethod method : methods) {
            ProgressManager.checkCanceled();
            PsiClass parentClass = method.getContainingClass();
            if ("java.lang.Object".equals(parentClass.getQualifiedName())) continue;
            classes.add(parentClass);
        }
        for (PsiClass aClass : classes) {
            AllOverridingMethodsSearch.search((PsiClass)aClass).forEach((Processor)new Processor<Pair<PsiMethod, PsiMethod>>((Set)overridden){
                final /* synthetic */ Set val$overridden;
                {
                    this.val$overridden = set2;
                }

                public boolean process(Pair<PsiMethod, PsiMethod> pair) {
                    PsiMethod superMethod = (PsiMethod)pair.getFirst();
                    if (superMethod.isPhysical() && ((PsiMethod)pair.getSecond()).isPhysical() && methods.remove(superMethod)) {
                        this.val$overridden.add(superMethod);
                    }
                    return !methods.isEmpty();
                }
            });
        }
        for (PsiMethod method : overridden) {
            boolean overrides = !method.hasModifierProperty("abstract");
            Icon icon = overrides ? OVERRIDEN_METHOD_MARKER_RENDERER : IMPLEMENTED_METHOD_MARKER_RENDERER;
            PsiIdentifier range = method.getNameIdentifier();
            if (range == null) {
                range = method;
            }
            MarkerType type = MarkerType.OVERRIDEN_METHOD;
            LineMarkerInfo info = new LineMarkerInfo((PsiElement)range, range.getTextRange(), icon, 6, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            result.add(info);
        }
    }

    static {
        IMPLEMENTED_INTERFACE_MARKER_RENDERER = IMPLEMENTED_METHOD_MARKER_RENDERER = IconLoader.getIcon((String)"/gutter/implementedMethod.png");
        SUBCLASSED_CLASS_MARKER_RENDERER = OVERRIDEN_METHOD_MARKER_RENDERER;
    }
}

