/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceProviderBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.theoryinpractice.testng.inspection.DependsOnGroupsInspection;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.DataProvider;

public class TestNGReferenceContributor
extends PsiReferenceContributor {
    private static PsiElementPattern.Capture<PsiLiteralExpression> getElementPattern(String annotation) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiLiteralExpression.class).and((ElementPattern)new FilterPattern((ElementFilter)new TestAnnotationFilter(annotation)));
    }

    public void registerReferenceProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(TestNGReferenceContributor.getElementPattern("dependsOnMethods"), (PsiReferenceProvider)new PsiReferenceProviderBase(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/TestNGReferenceContributor$1.getReferencesByElement must not be null");
                }
                if (context == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/TestNGReferenceContributor$1.getReferencesByElement must not be null");
                }
                MethodReference[] methodReferenceArray = new MethodReference[]{new MethodReference((PsiLiteralExpression)element)};
                if (methodReferenceArray == null) {
                    throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/TestNGReferenceContributor$1.getReferencesByElement must not return null");
                }
                return methodReferenceArray;
            }
        });
        registrar.registerReferenceProvider(TestNGReferenceContributor.getElementPattern("dataProvider"), (PsiReferenceProvider)new PsiReferenceProviderBase(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/TestNGReferenceContributor$2.getReferencesByElement must not be null");
                }
                if (context == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/TestNGReferenceContributor$2.getReferencesByElement must not be null");
                }
                DataProviderReference[] dataProviderReferenceArray = new DataProviderReference[]{new DataProviderReference((PsiLiteralExpression)element)};
                if (dataProviderReferenceArray == null) {
                    throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/TestNGReferenceContributor$2.getReferencesByElement must not return null");
                }
                return dataProviderReferenceArray;
            }
        });
        registrar.registerReferenceProvider(TestNGReferenceContributor.getElementPattern("groups"), (PsiReferenceProvider)new PsiReferenceProviderBase(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/TestNGReferenceContributor$3.getReferencesByElement must not be null");
                }
                if (context == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/TestNGReferenceContributor$3.getReferencesByElement must not be null");
                }
                GroupReference[] groupReferenceArray = new GroupReference[]{new GroupReference(element.getProject(), (PsiLiteralExpression)element)};
                if (groupReferenceArray == null) {
                    throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/TestNGReferenceContributor$3.getReferencesByElement must not return null");
                }
                return groupReferenceArray;
            }
        });
        registrar.registerReferenceProvider(TestNGReferenceContributor.getElementPattern("dependsOnGroups"), (PsiReferenceProvider)new PsiReferenceProviderBase(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/TestNGReferenceContributor$4.getReferencesByElement must not be null");
                }
                if (context == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/TestNGReferenceContributor$4.getReferencesByElement must not be null");
                }
                GroupReference[] groupReferenceArray = new GroupReference[]{new GroupReference(element.getProject(), (PsiLiteralExpression)element)};
                if (groupReferenceArray == null) {
                    throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/TestNGReferenceContributor$4.getReferencesByElement must not return null");
                }
                return groupReferenceArray;
            }
        });
    }

    private static class TestAnnotationFilter
    implements ElementFilter {
        private final String myParameterName;

        public TestAnnotationFilter(@NotNull @NonNls String parameterName) {
            if (parameterName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/TestNGReferenceContributor$TestAnnotationFilter.<init> must not be null");
            }
            this.myParameterName = parameterName;
        }

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiNameValuePair pair = (PsiNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)context, PsiNameValuePair.class);
            if (null == pair) {
                return false;
            }
            if (!this.myParameterName.equals(pair.getName())) {
                return false;
            }
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair, PsiAnnotation.class);
            if (annotation == null) {
                return false;
            }
            return TestNGUtil.isTestNGAnnotation(annotation);
        }

        public boolean isClassAcceptable(Class hintClass) {
            return PsiLiteralExpression.class.isAssignableFrom(hintClass);
        }
    }

    private static class GroupReference
    extends PsiReferenceBase<PsiLiteralExpression> {
        private final Project myProject;

        public GroupReference(Project project, PsiLiteralExpression element) {
            super((PsiElement)element, false);
            this.myProject = project;
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public Object[] getVariants() {
            Object[] objectArray;
            ArrayList<Object> list = new ArrayList<Object>();
            InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance((Project)this.myProject).getInspectionProfile();
            InspectionProfileEntry inspectionTool = inspectionProfile.getInspectionTool(DependsOnGroupsInspection.SHORT_NAME, this.myElement);
            DependsOnGroupsInspection inspection = (DependsOnGroupsInspection)((LocalInspectionToolWrapper)inspectionTool).getTool();
            for (String groupName : inspection.groups) {
                list.add(LookupValueFactory.createLookupValue((String)groupName, null));
            }
            if (!list.isEmpty()) {
                objectArray = list.toArray();
                if (objectArray == null) throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/TestNGReferenceContributor$GroupReference.getVariants must not return null");
                return objectArray;
            }
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            if (ArrayUtil.EMPTY_OBJECT_ARRAY != null) return objectArray;
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/TestNGReferenceContributor$GroupReference.getVariants must not return null");
        }
    }

    private static class MethodReference
    extends PsiReferenceBase<PsiLiteralExpression> {
        public MethodReference(PsiLiteralExpression element) {
            super((PsiElement)element, false);
        }

        @Nullable
        public PsiElement resolve() {
            PsiClass cls = PsiUtil.getTopLevelClass((PsiElement)this.getElement());
            if (cls != null) {
                PsiMethod[] methods = cls.getMethods();
                String val = this.getValue();
                int hackIndex = val.indexOf("IntellijIdeaRulezzz ");
                if (hackIndex > -1) {
                    val = val.substring(0, hackIndex) + val.substring(hackIndex + 1, val.length());
                }
                for (PsiMethod method : methods) {
                    if (!TestNGUtil.hasTest((PsiModifierListOwner)method) || !method.getName().equals(val)) continue;
                    return method;
                }
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList<Object> list = new ArrayList<Object>();
            PsiClass cls = PsiUtil.getTopLevelClass((PsiElement)this.getElement());
            if (cls != null) {
                PsiMethod[] methods;
                PsiMethod current = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiMethod.class);
                for (PsiMethod method : methods = cls.getMethods()) {
                    if (current != null && method.getName().equals(current.getName()) || !TestNGUtil.hasTest((PsiModifierListOwner)method) && !TestNGUtil.hasConfig((PsiModifierListOwner)method)) continue;
                    list.add(LookupValueFactory.createLookupValue((String)method.getName(), null));
                }
            }
            Object[] objectArray = list.toArray();
            if (objectArray == null) {
                throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/TestNGReferenceContributor$MethodReference.getVariants must not return null");
            }
            return objectArray;
        }
    }

    private static class DataProviderReference
    extends PsiReferenceBase<PsiLiteralExpression> {
        public DataProviderReference(PsiLiteralExpression element) {
            super((PsiElement)element, false);
        }

        @Nullable
        public PsiElement resolve() {
            PsiClass cls = PsiUtil.getTopLevelClass((PsiElement)this.getElement());
            if (cls != null) {
                PsiMethod[] methods = cls.getMethods();
                String val = this.getValue();
                for (PsiMethod method : methods) {
                    PsiNameValuePair[] values;
                    PsiAnnotation dataProviderAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{DataProvider.class.getName()});
                    if (dataProviderAnnotation == null) continue;
                    for (PsiNameValuePair value : values = dataProviderAnnotation.getParameterList().getAttributes()) {
                        if (!"name".equals(value.getName()) || !val.equals(StringUtil.unquoteString((String)value.getText()))) continue;
                        return method;
                    }
                    if (!val.equals(method.getName())) continue;
                    return method;
                }
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList<Object> list = new ArrayList<Object>();
            PsiClass cls = PsiUtil.getTopLevelClass((PsiElement)this.getElement());
            if (cls != null) {
                PsiMethod[] methods;
                PsiMethod current = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiMethod.class);
                for (PsiMethod method : methods = cls.getMethods()) {
                    PsiNameValuePair[] values;
                    PsiAnnotation dataProviderAnnotation;
                    if (current != null && method.getName().equals(current.getName()) || (dataProviderAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{DataProvider.class.getName()})) == null) continue;
                    boolean nameFoundInAttributes = false;
                    for (PsiNameValuePair value : values = dataProviderAnnotation.getParameterList().getAttributes()) {
                        PsiAnnotationMemberValue memberValue;
                        if (!"name".equals(value.getName()) || (memberValue = value.getValue()) == null) continue;
                        list.add(LookupValueFactory.createLookupValue((String)StringUtil.unquoteString((String)memberValue.getText()), null));
                        nameFoundInAttributes = true;
                        break;
                    }
                    if (nameFoundInAttributes) continue;
                    list.add(LookupValueFactory.createLookupValue((String)method.getName(), null));
                }
            }
            Object[] objectArray = list.toArray();
            if (objectArray == null) {
                throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/TestNGReferenceContributor$DataProviderReference.getVariants must not return null");
            }
            return objectArray;
        }
    }
}

