/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public class SignalWithoutCorrespondingAwaitInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("signal.without.corresponding.await.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SignalWithoutCorrespondingAwaitInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("signal.without.corresponding.await.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SignalWithoutCorrespondingAwaitInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SignalWithoutCorrespondingAwaitVisitor();
    }

    private static class ContainsAwaitVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiField target;
        private boolean containsAwait = false;

        ContainsAwaitVisitor(PsiField target) {
            this.target = target;
        }

        public void visitElement(PsiElement element) {
            if (this.containsAwait) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (!ThreadingUtils.isAwaitCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (referent == null) {
                return;
            }
            if (!this.target.equals(referent)) {
                return;
            }
            this.containsAwait = true;
        }

        public boolean containsAwait() {
            return this.containsAwait;
        }
    }

    private static class SignalWithoutCorrespondingAwaitVisitor
    extends BaseInspectionVisitor {
        private SignalWithoutCorrespondingAwaitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/SignalWithoutCorrespondingAwaitInspection$SignalWithoutCorrespondingAwaitVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!ThreadingUtils.isSignalOrSignalAllCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)fieldClass, (PsiElement)expression, (boolean)true)) {
                return;
            }
            if (SignalWithoutCorrespondingAwaitVisitor.containsAwaitCall(fieldClass, field)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean containsAwaitCall(PsiClass fieldClass, PsiField field) {
            ContainsAwaitVisitor visitor = new ContainsAwaitVisitor(field);
            fieldClass.accept((PsiElementVisitor)visitor);
            return visitor.containsAwait();
        }
    }
}

