/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryJavaDocLinkInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryJavaDocLinkInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryJavaDocLinkInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryJavaDocLinkFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryJavaDocLinkVisitor();
    }

    private static class UnnecessaryJavaDocLinkVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryJavaDocLinkVisitor() {
        }

        public void visitDocTag(PsiDocTag tag) {
            PsiElement target;
            super.visitDocTag(tag);
            String name = tag.getName();
            if ("link".equals(name) || "linkplain".equals(name) ? !(tag instanceof PsiInlineDocTag) : "see".equals(name) && tag instanceof PsiInlineDocTag) {
                return;
            }
            PsiElement[] dataElements = tag.getDataElements();
            if (dataElements.length == 0) {
                return;
            }
            PsiElement firstElement = dataElements[0];
            if (firstElement == null) {
                return;
            }
            PsiReference reference = firstElement.getReference();
            if (reference == null) {
                PsiElement[] children = firstElement.getChildren();
                if (children.length == 0) {
                    return;
                }
                PsiElement child = children[0];
                if (!(child instanceof PsiReference)) {
                    return;
                }
                reference = (PsiReference)child;
            }
            if ((target = reference.resolve()) == null) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiMethod.class);
            if (target.equals(containingMethod)) {
                this.registerError((PsiElement)tag, "@" + name);
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiClass.class);
            if (target.equals(containingClass)) {
                this.registerError((PsiElement)tag, "@" + name);
                return;
            }
            if (containingMethod == null) {
                return;
            }
            if (!(target instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)target;
            if (!UnnecessaryJavaDocLinkVisitor.isSuperMethod(method, containingMethod)) {
                return;
            }
            this.registerError((PsiElement)tag, "@" + name);
        }

        public static boolean isSuperMethod(PsiMethod superMethodCandidate, PsiMethod derivedMethod) {
            PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
            PsiClass derivedClass = derivedMethod.getContainingClass();
            if (derivedClass == null || superClassCandidate == null) {
                return false;
            }
            if (!derivedClass.isInheritor(superClassCandidate, false)) {
                return false;
            }
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClassCandidate, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
            MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
            return MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)derivedSignature);
        }
    }

    private static class UnnecessaryJavaDocLinkFix
    extends InspectionGadgetsFix {
        private final String tagName;

        public UnnecessaryJavaDocLinkFix(String tagName) {
            this.tagName = tagName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.quickfix", this.tagName);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryJavaDocLinkInspection$UnnecessaryJavaDocLinkFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiDocTag)) {
                return;
            }
            PsiDocTag docTag = (PsiDocTag)element;
            PsiDocComment docComment = docTag.getContainingComment();
            if (docComment != null && UnnecessaryJavaDocLinkFix.shouldDeleteEntireComment(docComment)) {
                docComment.delete();
                return;
            }
            docTag.delete();
        }

        private static boolean shouldDeleteEntireComment(PsiDocComment docComment) {
            PsiDocToken[] docTokens = (PsiDocToken[])PsiTreeUtil.getChildrenOfType((PsiElement)docComment, PsiDocToken.class);
            if (docTokens == null) {
                return false;
            }
            for (PsiDocToken docToken : docTokens) {
                IElementType tokenType = docToken.getTokenType();
                if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType) || StringUtil.isEmptyOrSpaces((String)docToken.getText())) continue;
                return false;
            }
            return true;
        }
    }
}

