/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.performance.MethodReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClassInitializerMayBeStaticInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.initializer.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ClassInitializerMayBeStaticInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("static");
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.initializer.may.be.static.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ClassInitializerMayBeStaticInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassInitializerCanBeStaticVisitor();
    }

    private static class ClassInitializerCanBeStaticVisitor
    extends BaseInspectionVisitor {
        private ClassInitializerCanBeStaticVisitor() {
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            Condition[] addins;
            if (initializer.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)initializer);
            if (containingClass == null) {
                return;
            }
            ExtensionsArea rootArea = Extensions.getRootArea();
            ExtensionPoint extensionPoint = rootArea.getExtensionPoint("com.intellij.cantBeStatic");
            for (Condition addin : addins = (Condition[])extensionPoint.getExtensions()) {
                if (!addin.value((Object)initializer)) continue;
                return;
            }
            PsiElement scope = containingClass.getScope();
            if (!(scope instanceof PsiJavaFile) && !containingClass.hasModifierProperty("static")) {
                return;
            }
            MethodReferenceVisitor visitor = new MethodReferenceVisitor((PsiMember)initializer);
            initializer.accept((PsiElementVisitor)visitor);
            if (!visitor.areReferencesStaticallyAccessible()) {
                return;
            }
            this.registerClassInitializerError(initializer, new Object[0]);
        }
    }
}

