/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticMethodOnlyUsedInOneClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        PsiNamedElement element = (PsiNamedElement)infos[0];
        String name = element.getName();
        if (infos.length > 1) {
            if (!(Boolean.TRUE.equals(infos[1]) ? (string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor.anonymous.extending", name)) != null : (string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor.anonymous.implementing", name)) != null)) throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor", name);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection.buildErrorString must not return null");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass usageClass = (PsiClass)infos[0];
        return new StaticMethodOnlyUsedInOneClassFix(usageClass);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticMethodOnlyUsedInOneClassVisitor();
    }

    private static class UsageProcessor
    implements Processor<PsiReference> {
        private final AtomicReference<PsiClass> foundClass = new AtomicReference();

        private UsageProcessor() {
        }

        public boolean process(PsiReference reference) {
            ProgressManager.checkCanceled();
            PsiElement element = reference.getElement();
            PsiClass usageClass = ClassUtils.getContainingClass(element);
            if (usageClass == null) {
                return true;
            }
            if (this.foundClass.compareAndSet(null, usageClass)) {
                return true;
            }
            PsiClass aClass = this.foundClass.get();
            PsiManager manager = usageClass.getManager();
            return manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)usageClass);
        }

        @Nullable
        public PsiClass getUsageClass(final PsiMethod method) {
            GlobalSearchScope scope;
            String name;
            ProgressManager progressManager = ProgressManager.getInstance();
            PsiManager manager = method.getManager();
            PsiSearchHelper searchHelper = manager.getSearchHelper();
            if (searchHelper.isCheapEnoughToSearch(name = method.getName(), scope = GlobalSearchScope.allScope((Project)method.getProject()), null, progressManager.getProgressIndicator()) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return null;
            }
            progressManager.runProcess(new Runnable(){

                @Override
                public void run() {
                    Query query = MethodReferencesSearch.search((PsiMethod)method);
                    if (!query.forEach((Processor)UsageProcessor.this)) {
                        UsageProcessor.this.foundClass.set(null);
                    }
                }
            }, null);
            return this.foundClass.get();
        }
    }

    private static class StaticMethodOnlyUsedInOneClassVisitor
    extends BaseInspectionVisitor {
        private StaticMethodOnlyUsedInOneClassVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!method.hasModifierProperty("static")) {
                return;
            }
            if (method.hasModifierProperty("private")) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            UsageProcessor usageProcessor = new UsageProcessor();
            PsiClass usageClass = usageProcessor.getUsageClass(method);
            if (usageClass == null) {
                return;
            }
            if (usageClass.equals(method.getContainingClass())) {
                return;
            }
            if (usageClass instanceof PsiAnonymousClass) {
                PsiClass[] interfaces = usageClass.getInterfaces();
                if (interfaces.length == 1) {
                    PsiClass superClass = interfaces[0];
                    this.registerMethodError(method, superClass, Boolean.FALSE);
                } else {
                    PsiClass superClass = usageClass.getSuperClass();
                    if (superClass == null) {
                        return;
                    }
                    this.registerMethodError(method, superClass, Boolean.TRUE);
                }
            } else {
                this.registerMethodError(method, usageClass);
            }
        }
    }

    private static class StaticMethodOnlyUsedInOneClassFix
    extends InspectionGadgetsFix {
        private final PsiClass usageClass;

        public StaticMethodOnlyUsedInOneClassFix(PsiClass usageClass) {
            this.usageClass = usageClass;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$StaticMethodOnlyUsedInOneClassFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(final @NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$StaticMethodOnlyUsedInOneClassFix.doFix must not be null");
            }
            PsiElement location = descriptor.getPsiElement();
            final PsiMethod method = (PsiMethod)location.getParent();
            Application application = ApplicationManager.getApplication();
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RefactoringActionHandlerFactory factory = RefactoringActionHandlerFactory.getInstance();
                    RefactoringActionHandler moveHandler = factory.createMoveHandler();
                    final DataManager dataManager = DataManager.getInstance();
                    DataContext dataContext = new DataContext(){

                        public Object getData(@NonNls String name) {
                            if (LangDataKeys.TARGET_PSI_ELEMENT.is(name)) {
                                return StaticMethodOnlyUsedInOneClassFix.this.usageClass;
                            }
                            return dataManager.getDataContext().getData(name);
                        }
                    };
                    moveHandler.invoke(project, new PsiElement[]{method}, dataContext);
                }
            });
        }
    }
}

