/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public abstract class BaseInspectionVisitor
extends JavaElementVisitor {
    private BaseInspection inspection = null;
    private boolean onTheFly = false;
    private ProblemsHolder holder = null;

    final void setInspection(BaseInspection inspection) {
        this.inspection = inspection;
    }

    final void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    public final boolean isOnTheFly() {
        return this.onTheFly;
    }

    protected final void registerNewExpressionError(@NotNull PsiNewExpression expression, Object ... infos) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerNewExpressionError must not be null");
        }
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        if (classReference == null) {
            this.registerError((PsiElement)expression, infos);
        } else {
            this.registerError((PsiElement)classReference, infos);
        }
    }

    protected final void registerMethodCallError(@NotNull PsiMethodCallExpression expression, Object ... infos) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerMethodCallError must not be null");
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiElement nameToken = methodExpression.getReferenceNameElement();
        if (nameToken == null) {
            this.registerError((PsiElement)expression, infos);
        } else {
            this.registerError(nameToken, infos);
        }
    }

    protected final void registerStatementError(@NotNull PsiStatement statement, Object ... infos) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerStatementError must not be null");
        }
        PsiElement statementToken = statement.getFirstChild();
        if (statementToken == null) {
            this.registerError((PsiElement)statement, infos);
        } else {
            this.registerError(statementToken, infos);
        }
    }

    protected final void registerClassError(@NotNull PsiClass aClass, Object ... infos) {
        PsiIdentifier nameIdentifier;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerClassError must not be null");
        }
        if (aClass instanceof PsiEnumConstantInitializer) {
            PsiEnumConstantInitializer enumConstantInitializer = (PsiEnumConstantInitializer)aClass;
            PsiEnumConstant enumConstant = enumConstantInitializer.getEnumConstant();
            nameIdentifier = enumConstant.getNameIdentifier();
        } else if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            nameIdentifier = anonymousClass.getBaseClassReference();
        } else {
            nameIdentifier = aClass.getNameIdentifier();
        }
        if (nameIdentifier == null) {
            this.registerError((PsiElement)aClass.getContainingFile(), infos);
        } else {
            this.registerError((PsiElement)nameIdentifier, infos);
        }
    }

    protected final void registerMethodError(@NotNull PsiMethod method, Object ... infos) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerMethodError must not be null");
        }
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (nameIdentifier == null) {
            this.registerError((PsiElement)method.getContainingFile(), infos);
        } else {
            this.registerError((PsiElement)nameIdentifier, infos);
        }
    }

    protected final void registerVariableError(@NotNull PsiVariable variable, Object ... infos) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerVariableError must not be null");
        }
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        if (nameIdentifier == null) {
            this.registerError((PsiElement)variable, infos);
        } else {
            this.registerError((PsiElement)nameIdentifier, infos);
        }
    }

    protected final void registerTypeParameterError(@NotNull PsiTypeParameter typeParameter, Object ... infos) {
        if (typeParameter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerTypeParameterError must not be null");
        }
        PsiIdentifier nameIdentifier = typeParameter.getNameIdentifier();
        if (nameIdentifier == null) {
            this.registerError((PsiElement)typeParameter, infos);
        } else {
            this.registerError((PsiElement)nameIdentifier, infos);
        }
    }

    protected final void registerFieldError(@NotNull PsiField field, Object ... infos) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerFieldError must not be null");
        }
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        this.registerError((PsiElement)nameIdentifier, infos);
    }

    protected final void registerModifierError(@NotNull String modifier, @NotNull PsiModifierListOwner parameter, Object ... infos) {
        PsiElement[] children;
        if (modifier == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerModifierError must not be null");
        }
        if (parameter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerModifierError must not be null");
        }
        PsiModifierList modifiers = parameter.getModifierList();
        if (modifiers == null) {
            return;
        }
        for (PsiElement child : children = modifiers.getChildren()) {
            String text = child.getText();
            if (!modifier.equals(text)) continue;
            this.registerError(child, infos);
        }
    }

    protected final void registerClassInitializerError(@NotNull PsiClassInitializer initializer, Object ... infos) {
        if (initializer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerClassInitializerError must not be null");
        }
        PsiCodeBlock body = initializer.getBody();
        PsiJavaToken lBrace = body.getLBrace();
        if (lBrace == null) {
            this.registerError((PsiElement)initializer, infos);
        } else {
            this.registerError((PsiElement)lBrace, infos);
        }
    }

    protected final void registerError(@NotNull PsiElement location, Object ... infos) {
        LocalQuickFix[] fixes;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspectionVisitor.registerError must not be null");
        }
        if (location.getTextLength() == 0) {
            return;
        }
        for (InspectionGadgetsFix inspectionGadgetsFix : fixes = this.createFixes(infos)) {
            inspectionGadgetsFix.setOnTheFly(this.onTheFly);
        }
        String description = this.inspection.buildErrorString(infos);
        this.holder.registerProblem(location, description, fixes);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private InspectionGadgetsFix[] createFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray;
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            inspectionGadgetsFixArray = InspectionGadgetsFix.EMPTY_ARRAY;
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseInspectionVisitor.createFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] fixes = this.inspection.buildFixes(infos);
        if (fixes.length > 0) {
            inspectionGadgetsFixArray = fixes;
            if (fixes == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseInspectionVisitor.createFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix fix = this.inspection.buildFix(infos);
        if (fix == null) {
            inspectionGadgetsFixArray = InspectionGadgetsFix.EMPTY_ARRAY;
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseInspectionVisitor.createFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        inspectionGadgetsFixArray = new InspectionGadgetsFix[]{fix};
        if (inspectionGadgetsFixArray != null) return inspectionGadgetsFixArray;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseInspectionVisitor.createFixes must not return null");
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        this.visitExpression((PsiExpression)expression);
    }

    public final void visitWhiteSpace(PsiWhiteSpace space) {
    }

    public final void setProblemsHolder(ProblemsHolder holder) {
        this.holder = holder;
    }
}

