/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.rt.execution.junit.ComparisonDetailsExtractor;
import com.intellij.rt.execution.junit.ExceptionPacketFactory;
import com.intellij.rt.execution.junit.KnownException;
import com.intellij.rt.execution.junit.PacketFactory;
import com.intellij.rt.execution.junit.TestMeter;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.Packet;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import junit.framework.ComparisonFailure;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4TestResultsSender
extends RunListener {
    private final OutputObjectRegistry myRegistry;
    private final PacketProcessor myErr;
    private TestMeter myCurrentTestMeter;
    private Description myCurrentTest;
    static /* synthetic */ Class class$org$junit$Ignore;

    public JUnit4TestResultsSender(OutputObjectRegistry packetFactory, PacketProcessor segmentedErr) {
        this.myRegistry = packetFactory;
        this.myErr = segmentedErr;
    }

    public synchronized void testFailure(Failure failure) throws Exception {
        Description description = failure.getDescription();
        Throwable throwable = failure.getException();
        if (throwable instanceof AssertionError) {
            this.doAddFailure(description, (Error)throwable);
        } else {
            if (description.equals((Object)this.myCurrentTest)) {
                this.stopMeter(description);
            }
            this.prepareDefectPacket(description, throwable).send();
        }
    }

    public synchronized void testIgnored(Description description) throws Exception {
        String val = null;
        try {
            Ignore ignoredAnnotation = (Ignore)description.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestResultsSender.class$("org.junit.Ignore")) : class$org$junit$Ignore);
            if (ignoredAnnotation != null) {
                val = ignoredAnnotation.value();
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.testStarted(description);
        this.stopMeter(description);
        this.prepareIgnoredPacket(description, val).send();
    }

    private void doAddFailure(Description test, Throwable assertion) {
        if (test.equals((Object)this.myCurrentTest)) {
            this.stopMeter(test);
        }
        JUnit4TestResultsSender.createExceptionNotification(assertion).createPacket(this.myRegistry, (Object)test).send();
    }

    private static PacketFactory createExceptionNotification(Throwable assertion) {
        if (assertion instanceof KnownException) {
            return ((KnownException)((Object)assertion)).getPacketFactory();
        }
        if (assertion instanceof ComparisonFailure || assertion.getClass().getName().equals("org.junit.ComparisonFailure")) {
            return ComparisonDetailsExtractor.create(assertion);
        }
        return new ExceptionPacketFactory(6, assertion);
    }

    private Packet prepareDefectPacket(Description test, Throwable assertion) {
        return this.myRegistry.createPacket().setTestState((Object)test, 8).addThrowable(assertion);
    }

    private Packet prepareIgnoredPacket(Description test, String val) {
        return this.myRegistry.createPacket().setTestState((Object)test, 5).addObject((Object)test).addLimitedString(val != null ? val : "");
    }

    public void testFinished(Description description) throws Exception {
        this.stopMeter(description);
        Packet packet = this.myRegistry.createPacket().setTestState((Object)description, 1);
        this.myCurrentTestMeter.writeTo(packet);
        packet.send();
        this.myRegistry.forget((Object)description);
    }

    private void stopMeter(Description test) {
        if (!test.equals((Object)this.myCurrentTest)) {
            this.myCurrentTestMeter = new TestMeter();
            System.err.println("Wrong test finished. Last started: " + this.myCurrentTest + " stopped: " + test + "; " + test.getClass());
        }
        this.myCurrentTestMeter.stop();
    }

    private void switchOutput(Packet switchPacket) {
        switchPacket.send();
        switchPacket.sendThrough(this.myErr);
    }

    public synchronized void testStarted(Description description) throws Exception {
        this.myCurrentTest = description;
        this.myRegistry.createPacket().setTestState((Object)description, 3).send();
        this.switchOutput(this.myRegistry.createPacket().switchInputTo((Object)description));
        this.myCurrentTestMeter = new TestMeter();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

