/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.UniqueNameGenerator;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.options.Options;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import com.maddyhome.idea.copyright.util.NewFileTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CopyrightManager", storages={@Storage(id="default", file="$PROJECT_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/copyright/", scheme=StorageScheme.DIRECTORY_BASED, stateSplitter=CopyrightStateSplitter.class)})
public class CopyrightManager
extends AbstractProjectComponent
implements JDOMExternalizable,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CopyrightManager.class.getName()));
    @Nullable
    private CopyrightProfile myDefaultCopyright = null;
    private final LinkedHashMap<String, String> myModule2Copyrights = new LinkedHashMap();
    private final Map<String, CopyrightProfile> myCopyrights = new HashMap();
    private final Options myOptions = new Options();
    @NonNls
    private static final String COPYRIGHT = "copyright";
    @NonNls
    private static final String MODULE2COPYRIGHT = "module2copyright";
    @NonNls
    private static final String ELEMENT = "element";
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String DEFAULT = "default";

    public CopyrightManager(Project project) {
        super(project);
    }

    public static CopyrightManager getInstance(Project project) {
        return (CopyrightManager)((Object)project.getComponent(CopyrightManager.class));
    }

    public void projectOpened() {
        if (this.myProject != null) {
            FileEditorManagerAdapter listener = new FileEditorManagerAdapter(){

                public void fileOpened(FileEditorManager fileEditorManager, VirtualFile virtualFile) {
                    if (virtualFile.isWritable() && NewFileTracker.getInstance().contains(virtualFile)) {
                        PsiFile file;
                        Module module;
                        NewFileTracker.getInstance().remove(virtualFile);
                        if (FileTypeUtil.getInstance().isSupportedFile(virtualFile) && (module = ProjectRootManager.getInstance((Project)CopyrightManager.this.myProject).getFileIndex().getModuleForFile(virtualFile)) != null && (file = PsiManager.getInstance((Project)CopyrightManager.this.myProject).findFile(virtualFile)) != null) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (file.isValid() && file.isWritable()) {
                                        new UpdateCopyrightProcessor(CopyrightManager.this.myProject, module, file).run();
                                    }
                                }
                            });
                        }
                    }
                }
            };
            FileEditorManager.getInstance((Project)this.myProject).addFileEditorManagerListener((FileEditorManagerListener)listener, (Disposable)this.myProject);
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("CopyrightManager" == null) {
            throw new IllegalStateException("@NotNull method com/maddyhome/idea/copyright/CopyrightManager.getComponentName must not return null");
        }
        return "CopyrightManager";
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.clearCopyrights();
        Element module2copyright = element.getChild(MODULE2COPYRIGHT);
        if (module2copyright != null) {
            for (Object o : module2copyright.getChildren(ELEMENT)) {
                Element el = (Element)o;
                String moduleName = el.getAttributeValue(MODULE);
                String copyrightName = el.getAttributeValue(COPYRIGHT);
                this.myModule2Copyrights.put(moduleName, copyrightName);
            }
        }
        for (Object o : element.getChildren(COPYRIGHT)) {
            CopyrightProfile copyrightProfile = new CopyrightProfile();
            copyrightProfile.readExternal((Element)o);
            this.myCopyrights.put(copyrightProfile.getName(), copyrightProfile);
        }
        this.myDefaultCopyright = this.myCopyrights.get(element.getAttributeValue(DEFAULT));
        this.myOptions.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (CopyrightProfile copyright : this.myCopyrights.values()) {
            Element copyrightElement = new Element(COPYRIGHT);
            copyright.writeExternal(copyrightElement);
            element.addContent(copyrightElement);
        }
        Element map = new Element(MODULE2COPYRIGHT);
        for (String moduleName : this.myModule2Copyrights.keySet()) {
            Element setting = new Element(ELEMENT);
            setting.setAttribute(MODULE, moduleName);
            setting.setAttribute(COPYRIGHT, this.myModule2Copyrights.get(moduleName));
            map.addContent(setting);
        }
        element.addContent(map);
        element.setAttribute(DEFAULT, this.myDefaultCopyright != null ? this.myDefaultCopyright.getName() : "");
        this.myOptions.writeExternal(element);
    }

    public Element getState() {
        try {
            Element e = new Element("settings");
            this.writeExternal(e);
            return e;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public Map<String, String> getCopyrightsMapping() {
        return this.myModule2Copyrights;
    }

    public void setDefaultCopyright(@Nullable CopyrightProfile copyright) {
        this.myDefaultCopyright = copyright;
    }

    @Nullable
    public CopyrightProfile getDefaultCopyright() {
        return this.myDefaultCopyright;
    }

    public void addCopyright(CopyrightProfile copyrightProfile) {
        this.myCopyrights.put(copyrightProfile.getName(), copyrightProfile);
    }

    public void removeCopyright(CopyrightProfile copyrightProfile) {
        this.myCopyrights.values().remove((Object)copyrightProfile);
        Iterator<String> it = this.myModule2Copyrights.keySet().iterator();
        while (it.hasNext()) {
            String profileName = this.myModule2Copyrights.get(it.next());
            if (!profileName.equals(copyrightProfile.getName())) continue;
            it.remove();
        }
    }

    public void clearCopyrights() {
        this.myDefaultCopyright = null;
        this.myCopyrights.clear();
        this.myModule2Copyrights.clear();
    }

    public void mapCopyright(String scopeName, String copyrightProfileName) {
        this.myModule2Copyrights.put(scopeName, copyrightProfileName);
    }

    public void unmapCopyright(String scopeName) {
        this.myModule2Copyrights.remove(scopeName);
    }

    public Collection<CopyrightProfile> getCopyrights() {
        return this.myCopyrights.values();
    }

    @Nullable
    public CopyrightProfile getCopyrightOptions(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/maddyhome/idea/copyright/CopyrightManager.getCopyrightOptions must not be null");
        }
        if (this.myOptions.getOptions(file.getFileType().getName()).getFileTypeOverride() == 1) {
            return null;
        }
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        for (String scopeName : this.myModule2Copyrights.keySet()) {
            CopyrightProfile profile;
            PackageSet packageSet;
            NamedScope namedScope = validationManager.getScope(scopeName);
            if (namedScope == null || (packageSet = namedScope.getValue()) == null || !packageSet.contains(file, (NamedScopesHolder)validationManager) || (profile = this.myCopyrights.get(this.myModule2Copyrights.get(scopeName))) == null) continue;
            return profile;
        }
        return this.myDefaultCopyright != null ? this.myDefaultCopyright : null;
    }

    public Options getOptions() {
        return this.myOptions;
    }

    public void replaceCopyright(String displayName, CopyrightProfile copyrightProfile) {
        if (this.myDefaultCopyright != null && Comparing.strEqual((String)this.myDefaultCopyright.getName(), (String)displayName)) {
            this.myDefaultCopyright = copyrightProfile;
        }
        this.myCopyrights.remove(displayName);
        this.addCopyright(copyrightProfile);
    }

    public static class CopyrightStateSplitter
    implements StateSplitter {
        public List<Pair<Element, String>> splitState(Element e) {
            Element[] elements;
            UniqueNameGenerator generator = new UniqueNameGenerator();
            ArrayList<Pair<Element, String>> result = new ArrayList<Pair<Element, String>>();
            for (Element element : elements = JDOMUtil.getElements((Element)e)) {
                Element[] options;
                if (!element.getName().equals(CopyrightManager.COPYRIGHT)) continue;
                element.detach();
                String profileName = null;
                for (Element option : options = JDOMUtil.getElements((Element)element)) {
                    if (!option.getName().equals("option") || !option.getAttributeValue("name").equals("myName")) continue;
                    profileName = option.getAttributeValue("value");
                }
                assert (profileName != null);
                String name = generator.generateUniqueName(FileUtil.sanitizeFileName(profileName)) + ".xml";
                result.add((Pair<Element, String>)new Pair((Object)element, (Object)name));
            }
            result.add(new Pair((Object)e, (Object)(generator.generateUniqueName("profiles_settings") + ".xml")));
            return result;
        }

        public void mergeStatesInto(Element target, Element[] elements) {
            for (Element element : elements) {
                Element[] states;
                if (element.getName().equals(CopyrightManager.COPYRIGHT)) {
                    element.detach();
                    target.addContent(element);
                    continue;
                }
                for (Element state : states = JDOMUtil.getElements((Element)element)) {
                    state.detach();
                    target.addContent(state);
                }
                for (Object attr : element.getAttributes()) {
                    target.setAttribute((Attribute)((Attribute)attr).clone());
                }
            }
        }
    }
}

