#!/bin/sh
echo 'name: cryptohash
version: 0.7.0
id: cryptohash-0.7.0-793263c2f4739cc133806e158ecfb73d

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability:
homepage: http://github.com/vincenthz/hs-cryptohash
package-url:
description: A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
             with performance close to the fastest implementations available in others languages.
             .
             The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cryptohash
exposed: True
exposed-modules: Crypto.Hash.SHA1 Crypto.Hash.SHA224
                 Crypto.Hash.SHA256 Crypto.Hash.SHA384 Crypto.Hash.SHA512
                 Crypto.Hash.SHA512t Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
                 Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
                 Crypto.Hash.Tiger
hidden-modules:
import-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
library-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
hs-libraries: HScryptohash-0.7.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-912d55d387093f740e3bcd2ffbf1dd83
         bytestring-0.9.1.10-e7cebdd905566e960c42140389871ec1
         cereal-0.3.0.0-3cb8b258e48ebb16acfcc9dfed280198
         crypto-api-0.6.1-66a96a480344b527cd3ec6d9cc827075
         tagged-0.2-b0871a68a3ca203a7cd9949ee1a64545
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cryptohash-0.7.0/html/cryptohash.haddock
haddock-html: /usr/local/share/doc/hs-cryptohash-0.7.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
