#!/bin/sh
echo 'name: blaze-builder
version: 0.2.1.4
id: blaze-builder-0.2.1.4-ad5ca2b353a9c2419d1c843e4c41a350

license: BSD3
copyright: 2010 Simon Meier
           2010 Jasper Van der Jeugt
maintainer: Simon Meier <iridcode@gmail.com>
stability: Experimental
homepage: http://github.com/meiersi/blaze-builder
package-url:
description: This library provides an abstraction of buffered output of
             byte streams and several convenience functions to exploit
             it. For example, it allows to efficiently serialize
             Haskell values to lazy bytestrings with a large average
             chunk size. The large average chunk size allows to make
             good use of cache prefetching in later processing steps
             (e.g. compression) and reduces the sytem call overhead
             when writing the resulting lazy bytestring to a file or
             sending it over the network.
category: Data
author: Jasper Van der Jeugt, Simon Meier
pkgpath: devel/hs-blaze-builder
exposed: True
exposed-modules: Blaze.ByteString.Builder
                 Blaze.ByteString.Builder.Int Blaze.ByteString.Builder.Word
                 Blaze.ByteString.Builder.ByteString
                 Blaze.ByteString.Builder.Char.Utf8 Blaze.ByteString.Builder.Char8
                 Blaze.ByteString.Builder.Html.Utf8 Blaze.ByteString.Builder.HTTP
                 Blaze.ByteString.Builder.Internal
                 Blaze.ByteString.Builder.Internal.Write
                 Blaze.ByteString.Builder.Internal.Types
                 Blaze.ByteString.Builder.Internal.Buffer
hidden-modules: Blaze.ByteString.Builder.Internal.UncheckedShifts
import-dirs: /usr/local/lib/ghc/blaze-builder-0.2.1.4
library-dirs: /usr/local/lib/ghc/blaze-builder-0.2.1.4
hs-libraries: HSblaze-builder-0.2.1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-912d55d387093f740e3bcd2ffbf1dd83
         bytestring-0.9.1.10-e7cebdd905566e960c42140389871ec1
         text-0.11.0.6-ace87dcbd28176f4bf784c8b8e080ab9
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-blaze-builder-0.2.1.4/html/blaze-builder.haddock
haddock-html: /usr/local/share/doc/hs-blaze-builder-0.2.1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
