/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicLabelUI
extends LabelUI
implements PropertyChangeListener {
    protected static BasicLabelUI labelUI;
    private Rectangle vr = new Rectangle();
    private Rectangle ir = new Rectangle();
    private Rectangle tr = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        if (labelUI == null) {
            labelUI = new BasicLabelUI();
        }
        return labelUI;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Insets insets = jLabel.getInsets();
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        this.layoutCL(jLabel, fontMetrics, jLabel.getText(), jLabel.getIcon(), this.vr, this.ir, this.tr);
        Rectangle rectangle = SwingUtilities.computeUnion(this.tr.x, this.tr.y, this.tr.width, this.tr.height, this.ir);
        return new Dimension(insets.left + rectangle.width + insets.right, insets.top + rectangle.height + insets.bottom);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        JLabel jLabel = (JLabel)jComponent;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.vr = SwingUtilities.calculateInnerArea(jComponent, this.vr);
        if (this.vr.width < 0) {
            this.vr.width = 0;
        }
        if (this.vr.height < 0) {
            this.vr.height = 0;
        }
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        String string = this.layoutCL(jLabel, fontMetrics, jLabel.getText(), icon, this.vr, this.ir, this.tr);
        if (icon != null) {
            icon.paintIcon(jLabel, graphics, this.ir.x, this.ir.y);
        }
        if ((object = jLabel.getClientProperty("html")) == null) {
            if (string != null && !string.equals("")) {
                if (jLabel.isEnabled()) {
                    this.paintEnabledText(jLabel, graphics, string, this.tr.x, this.tr.y + fontMetrics.getAscent());
                } else {
                    this.paintDisabledText(jLabel, graphics, string, this.tr.x, this.tr.y + fontMetrics.getAscent());
                }
            }
        } else {
            ((View)object).paint(graphics, this.tr);
        }
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(jLabel.getBackground().brighter());
        int n3 = jLabel.getDisplayedMnemonicIndex();
        if (n3 != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, n, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
        graphics.setColor(jLabel.getBackground().darker());
        if (n3 != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, n + 1, n2 + 1);
        } else {
            graphics.drawString(string, n + 1, n2 + 1);
        }
        graphics.setColor(color);
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(jLabel.getForeground());
        int n3 = jLabel.getDisplayedMnemonicIndex();
        if (n3 != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, n, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
        graphics.setColor(color);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            this.installComponents(jLabel);
            this.installDefaults(jLabel);
            this.installListeners(jLabel);
            this.installKeyboardActions(jLabel);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            this.uninstallKeyboardActions(jLabel);
            this.uninstallListeners(jLabel);
            this.uninstallDefaults(jLabel);
            this.uninstallComponents(jLabel);
        }
    }

    protected void installComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, jLabel.getText());
    }

    protected void uninstallComponents(JLabel jLabel) {
        jLabel.putClientProperty("html", null);
        jLabel.putClientProperty("html.base", null);
    }

    protected void installDefaults(JLabel jLabel) {
        LookAndFeel.installColorsAndFont(jLabel, "Label.background", "Label.foreground", "Label.font");
    }

    protected void uninstallDefaults(JLabel jLabel) {
        jLabel.setForeground(null);
        jLabel.setBackground(null);
        jLabel.setFont(null);
    }

    protected void installKeyboardActions(JLabel jLabel) {
        int n;
        Component component = jLabel.getLabelFor();
        if (component != null && (n = jLabel.getDisplayedMnemonic()) > 0) {
            InputMap inputMap = new InputMap();
            inputMap.put(KeyStroke.getKeyStroke(n, 18), "press");
            SwingUtilities.replaceUIInputMap(jLabel, 2, inputMap);
            ActionMap actionMap = new ActionMap();
            actionMap.put("press", new AbstractAction(this){
                private /* synthetic */ BasicLabelUI this$0;
                {
                    this.this$0 = basicLabelUI;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JLabel jLabel = (JLabel)actionEvent.getSource();
                    Component component = jLabel.getLabelFor();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            });
            SwingUtilities.replaceUIActionMap(jLabel, actionMap);
        }
    }

    protected void uninstallKeyboardActions(JLabel jLabel) {
        SwingUtilities.replaceUIActionMap(jLabel, null);
        SwingUtilities.replaceUIInputMap(jLabel, 2, null);
    }

    protected void installListeners(JLabel jLabel) {
        jLabel.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JLabel jLabel) {
        jLabel.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("text")) {
            String string = (String)propertyChangeEvent.getNewValue();
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            BasicHTML.updateRenderer(jLabel, string);
        } else if (propertyChangeEvent.getPropertyName().equals("displayedMnemonic")) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            if (jLabel.getLabelFor() != null) {
                int n = (Integer)propertyChangeEvent.getOldValue();
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                InputMap inputMap = jLabel.getInputMap(2);
                inputMap.put(KeyStroke.getKeyStroke(n, 512), null);
                inputMap.put(KeyStroke.getKeyStroke(n2, 512), "press");
            }
        } else if (propertyChangeEvent.getPropertyName().equals("labelFor")) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            InputMap inputMap = jLabel.getInputMap(2);
            int n = jLabel.getDisplayedMnemonic();
            if (n > 0) {
                inputMap.put(KeyStroke.getKeyStroke(n, 512), "press");
            }
        }
    }
}

