/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableTocsArray;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.ui.RootScopePage;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.search.HelpWorkingSetElementLabelProvider;
import org.eclipse.help.ui.internal.search.HelpWorkingSetTreeContentProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InfoCenterPage
extends RootScopePage {
    private Text urlText;
    private Button searchAll;
    private Button searchSelected;
    private CheckboxTreeViewer tree;
    private ITreeContentProvider treeContentProvider;
    private ILabelProvider elementLabelProvider;
    private AdaptableTocsArray remoteTocs;
    private RemoteWorkingSet workingSet;
    private boolean tocStale;

    protected int createScopeContents(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(parent, 0);
        label.setText(Messages.InfoCenterPage_url);
        this.urlText = new Text(parent, 2048);
        this.urlText.setLayoutData((Object)new GridData(768));
        this.urlText.setEditable(this.getEngineDescriptor().isUserDefined());
        this.searchAll = new Button(parent, 16);
        this.searchAll.setText(Messages.selectAll);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.searchAll.setLayoutData((Object)gd);
        this.searchAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (InfoCenterPage.this.searchAll.getSelection()) {
                    InfoCenterPage.this.tree.getTree().setEnabled(false);
                }
            }
        });
        this.searchSelected = new Button(parent, 16);
        this.searchSelected.setText(Messages.selectWorkingSet);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.searchSelected.setLayoutData((Object)gd);
        this.searchSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (InfoCenterPage.this.searchSelected.getSelection()) {
                    InfoCenterPage.this.tree.getTree().setEnabled(true);
                    if (InfoCenterPage.this.tocStale) {
                        InfoCenterPage.this.updateTocs();
                    }
                }
            }
        });
        label = new Label(parent, 64);
        label.setFont(font);
        label.setText(Messages.WorkingSetContent);
        gd = new GridData(772);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.tree = new CheckboxTreeViewer(parent, 2816);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.horizontalSpan = 2;
        this.tree.getControl().setLayoutData((Object)gd);
        this.tree.getControl().setFont(font);
        this.treeContentProvider = new HelpWorkingSetTreeContentProvider();
        this.tree.setContentProvider((IContentProvider)this.treeContentProvider);
        this.elementLabelProvider = new HelpWorkingSetElementLabelProvider();
        this.tree.setLabelProvider((IBaseLabelProvider)this.elementLabelProvider);
        this.tree.setUseHashlookup(true);
        this.initializeControls();
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                InfoCenterPage.this.handleCheckStateChange(event);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                final Object element = event.getElement();
                if (!InfoCenterPage.this.tree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)InfoCenterPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            InfoCenterPage.this.setSubtreeChecked(element, InfoCenterPage.this.tree.getChecked(element), false);
                        }
                    });
                }
            }
        });
        return 2;
    }

    private void loadTocs(String urlName) {
        block17: {
            InputStream is;
            block16: {
                is = null;
                if (urlName == null || urlName.length() == 0) {
                    this.resetRemoteTocs();
                    return;
                }
                try {
                    try {
                        URL url = new URL(urlName);
                        url = new URL(url, "toc/");
                        URLConnection connection = url.openConnection();
                        is = connection.getInputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                        this.load(reader);
                        reader.close();
                    }
                    catch (MalformedURLException e) {
                        HelpUIPlugin.logError(Messages.InfoCenterPage_invalidURL, e, false, true);
                        this.resetRemoteTocs();
                        break block16;
                    }
                    catch (IOException e) {
                        HelpUIPlugin.logError(Messages.InfoCenterPage_tocError, e, false, true);
                        this.resetRemoteTocs();
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                break block17;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void resetRemoteTocs() {
        this.remoteTocs = new AdaptableTocsArray(new IToc[0]);
    }

    private void load(Reader r) {
        Document document = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = parser.parse(new InputSource(r));
            Node root = document.getFirstChild();
            while (root.getNodeType() == 8) {
                document.removeChild(root);
                root = document.getFirstChild();
            }
            this.load(document, (Element)root);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    private void load(Document doc, Element root) {
        ArrayList<5> list = new ArrayList<5>();
        NodeList engines = root.getElementsByTagName("toc");
        int i = 0;
        while (i < engines.getLength()) {
            final Node node = engines.item(i);
            IToc toc = new IToc(){

                public ITopic[] getTopics() {
                    return new ITopic[0];
                }

                public ITopic getTopic(String href) {
                    return null;
                }

                public String getHref() {
                    return node.getAttributes().getNamedItem("href").getNodeValue();
                }

                public String getLabel() {
                    return node.getAttributes().getNamedItem("label").getNodeValue();
                }
            };
            list.add(toc);
            ++i;
        }
        IToc[] tocs = list.toArray(new IToc[list.size()]);
        this.remoteTocs = new AdaptableTocsArray(tocs);
    }

    private void initializeControls() {
        IPreferenceStore store = this.getPreferenceStore();
        String url = store.getString(this.getKey("url"));
        if (url.length() == 0 && (url = (String)this.getEngineDescriptor().getParameters().get("url")) == null) {
            url = "";
        }
        this.urlText.setText(url);
        this.busyLoadTocs(url);
        this.workingSet = new RemoteWorkingSet();
        this.workingSet.load(store);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InfoCenterPage.this.tocStale = true;
            }
        });
        this.tree.setInput((Object)this.remoteTocs);
        boolean selected = store.getBoolean(this.getKey("searchSelected"));
        this.searchAll.setSelection(!selected);
        this.searchSelected.setSelection(selected);
        this.tree.getTree().setEnabled(selected);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] elements = InfoCenterPage.this.workingSet.getElements();
                InfoCenterPage.this.tree.setCheckedElements(elements);
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    if (InfoCenterPage.this.isExpandable(element)) {
                        InfoCenterPage.this.setSubtreeChecked(element, true, true);
                    }
                    InfoCenterPage.this.updateParentState(element, true);
                    ++i;
                }
            }
        });
    }

    private void updateTocs() {
        String url = this.urlText.getText();
        this.busyLoadTocs(url);
        this.tocStale = false;
        this.tree.setInput((Object)this.remoteTocs);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] elements = InfoCenterPage.this.workingSet.getElements();
                InfoCenterPage.this.tree.setCheckedElements(elements);
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    if (InfoCenterPage.this.isExpandable(element)) {
                        InfoCenterPage.this.setSubtreeChecked(element, true, true);
                    }
                    InfoCenterPage.this.updateParentState(element, true);
                    ++i;
                }
            }
        });
    }

    private void busyLoadTocs(final String url) {
        BusyIndicator.showWhile((Display)this.urlText.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                InfoCenterPage.this.loadTocs(url);
            }
        });
    }

    boolean isExpandable(Object element) {
        return this.treeContentProvider.hasChildren(element);
    }

    void updateParentState(Object child, boolean baseChildState) {
        if (child == null) {
            return;
        }
        Object parent = this.treeContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.treeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            if (this.tree.getChecked(children[i]) != baseChildState || this.tree.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        this.tree.setGrayed(parent, !allSameState);
        this.tree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState);
    }

    void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        Object[] children = this.treeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            if (state) {
                this.tree.setChecked(element, true);
                this.tree.setGrayed(element, false);
            } else {
                this.tree.setGrayChecked(element, false);
            }
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, checkExpandedState);
            }
            --i;
        }
    }

    private void findCheckedElements(List checkedResources, Object parent) {
        Object[] children = this.treeContentProvider.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (this.tree.getGrayed(children[i])) {
                this.findCheckedElements(checkedResources, children[i]);
            } else if (this.tree.getChecked(children[i])) {
                checkedResources.add(children[i]);
            }
            ++i;
        }
    }

    void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object element = event.getElement();
                boolean state = event.getChecked();
                InfoCenterPage.this.tree.setGrayed(element, false);
                if (InfoCenterPage.this.isExpandable(element)) {
                    InfoCenterPage.this.setSubtreeChecked(element, state, state);
                }
                InfoCenterPage.this.updateParentState(element, state);
            }
        });
    }

    public void updateWorkingSet() {
        ArrayList elements = new ArrayList(10);
        this.findCheckedElements(elements, this.tree.getInput());
        this.workingSet.setElements(elements.toArray(new AdaptableHelpResource[elements.size()]));
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.getEngineDescriptor().isUserDefined()) {
            store.setValue(this.getKey("url"), this.urlText.getText());
        }
        this.updateWorkingSet();
        this.workingSet.store(store);
        store.setValue(this.getKey("searchSelected"), this.searchSelected.getSelection());
        return super.performOk();
    }

    private String getKey(String key) {
        return String.valueOf(this.getEngineDescriptor().getId()) + "." + key;
    }

    class RemoteWorkingSet
    extends WorkingSet {
        public RemoteWorkingSet() {
            super("InfoCenter");
        }

        public void load(IPreferenceStore store) {
            String elements = store.getString(InfoCenterPage.this.getKey("tocs"));
            StringTokenizer stok = new StringTokenizer(elements, ";");
            ArrayList<AdaptableHelpResource> list = new ArrayList<AdaptableHelpResource>();
            while (stok.hasMoreTokens()) {
                String url = stok.nextToken();
                AdaptableHelpResource res = this.find(url);
                if (res == null) continue;
                list.add(res);
            }
            this.setElements(list.toArray(new AdaptableHelpResource[list.size()]));
        }

        private AdaptableHelpResource find(String url) {
            if (InfoCenterPage.this.remoteTocs == null) {
                return null;
            }
            IAdaptable[] children = InfoCenterPage.this.remoteTocs.getChildren();
            int i = 0;
            while (i < children.length) {
                AdaptableHelpResource res;
                IAdaptable child = children[i];
                if (child instanceof AdaptableHelpResource && (res = (AdaptableHelpResource)child).getHref().equals(url)) {
                    return res;
                }
                ++i;
            }
            return null;
        }

        public void store(IPreferenceStore store) {
            StringBuffer buf = new StringBuffer();
            AdaptableHelpResource[] elements = this.getElements();
            int i = 0;
            while (i < elements.length) {
                if (i > 0) {
                    buf.append(";");
                }
                buf.append(elements[i].getHref());
                ++i;
            }
            store.setValue(InfoCenterPage.this.getKey("tocs"), buf.toString());
        }
    }
}

