/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.PrintWriter;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.core.itarget.IEnvironmentInfo;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.target.TargetObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnvironmentInfo
extends TargetObject
implements IEnvironmentInfo {
    private static final long serialVersionUID = 1L;
    private String fOS;
    private String fWS;
    private String fArch;
    private String fNL;

    public EnvironmentInfo(ITargetModel model) {
        super(model);
    }

    public String getOS() {
        return this.fOS;
    }

    public String getWS() {
        return this.fWS;
    }

    public String getArch() {
        return this.fArch;
    }

    public String getNL() {
        return this.fNL;
    }

    public void setOS(String os) {
        String oldValue = this.fOS;
        this.fOS = os;
        this.firePropertyChanged("os", oldValue, this.fOS);
    }

    public void setWS(String ws) {
        String oldValue = this.fWS;
        this.fWS = ws;
        this.firePropertyChanged("ws", oldValue, this.fWS);
    }

    public void setArch(String arch) {
        String oldValue = this.fArch;
        this.fArch = arch;
        this.firePropertyChanged("arch", oldValue, this.fArch);
    }

    public void setNL(String nl) {
        String oldValue = this.fNL;
        this.fNL = nl;
        this.firePropertyChanged("nl", oldValue, this.fNL);
    }

    public void parse(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("os")) {
                    this.fOS = this.getText(child);
                } else if (child.getNodeName().equals("ws")) {
                    this.fWS = this.getText(child);
                } else if (child.getNodeName().equals("arch")) {
                    this.fArch = this.getText(child);
                } else if (child.getNodeName().equals("nl")) {
                    this.fNL = this.getText(child);
                }
            }
            ++i;
        }
    }

    private String getText(Node node) {
        node.normalize();
        Node text = node.getFirstChild();
        if (text != null && text.getNodeType() == 3) {
            return text.getNodeValue();
        }
        return "";
    }

    public void write(String indent, PrintWriter writer) {
        if (!(this.fOS != null && this.fOS.length() != 0 || this.fWS != null && this.fWS.length() != 0 || this.fArch != null && this.fArch.length() != 0 || this.fNL != null && this.fNL.length() != 0)) {
            return;
        }
        writer.println();
        writer.println(String.valueOf(indent) + "<environment>");
        if (this.fOS != null && this.fOS.length() > 0) {
            writer.println(String.valueOf(indent) + "   <" + "os" + ">" + this.getWritableString(this.fOS) + "</" + "os" + ">");
        }
        if (this.fWS != null && this.fWS.length() > 0) {
            writer.println(String.valueOf(indent) + "   <" + "ws" + ">" + this.getWritableString(this.fWS) + "</" + "ws" + ">");
        }
        if (this.fArch != null && this.fArch.length() > 0) {
            writer.println(String.valueOf(indent) + "   <" + "arch" + ">" + this.getWritableString(this.fArch) + "</" + "arch" + ">");
        }
        if (this.fNL != null && this.fNL.length() > 0) {
            writer.println(String.valueOf(indent) + "   <" + "nl" + ">" + this.getWritableString(this.fNL) + "</" + "nl" + ">");
        }
        writer.println(String.valueOf(indent) + "</environment>");
    }

    public String getDisplayOS() {
        if (this.fOS == null || this.fOS.trim().length() == 0) {
            return Platform.getOS();
        }
        return this.fOS.trim();
    }

    public String getDisplayWS() {
        if (this.fWS == null || this.fWS.trim().length() == 0) {
            return Platform.getWS();
        }
        return this.fWS.trim();
    }

    public String getDisplayArch() {
        if (this.fArch == null || this.fArch.trim().length() == 0) {
            return Platform.getOSArch();
        }
        return this.fArch.trim();
    }

    public String getDisplayNL() {
        if (this.fNL == null || this.fNL.trim().length() == 0) {
            return Platform.getNL();
        }
        return this.fNL.trim();
    }
}

