/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.w3c.dom.Node;

public class MoveAction
extends Action {
    protected List selectedNodes;
    protected Node parentNode;
    protected Node previousRefChild;
    protected Node nextRefChild;
    boolean doInsertBefore;
    List selectedComponentsList;
    XSDModelGroup parentModelGroup;
    XSDConcreteComponent previousRefComponent;
    XSDConcreteComponent nextRefComponent;

    public MoveAction(XSDModelGroup parentComponent, List selectedComponents, XSDConcreteComponent previousRefChildComponent, XSDConcreteComponent nextRefChildComponent) {
        this.parentModelGroup = parentComponent;
        this.selectedComponentsList = selectedComponents;
        this.previousRefComponent = previousRefChildComponent;
        this.nextRefComponent = nextRefChildComponent;
        this.selectedNodes = new ArrayList(selectedComponents.size());
        Iterator i = selectedComponents.iterator();
        while (i.hasNext()) {
            XSDConcreteComponent concreteComponent = (XSDConcreteComponent)i.next();
            this.selectedNodes.add(concreteComponent.getElement());
        }
        if (parentComponent == null) {
            return;
        }
        this.parentNode = parentComponent.getElement();
        this.nextRefChild = nextRefChildComponent != null ? nextRefChildComponent.getElement() : null;
        this.previousRefChild = previousRefChildComponent != null ? previousRefChildComponent.getElement() : null;
        boolean bl = this.doInsertBefore = this.nextRefChild != null;
        if (this.nextRefComponent != null && this.nextRefComponent.getContainer().getContainer() == this.parentModelGroup) {
            this.doInsertBefore = true;
        }
        if (this.previousRefComponent != null && this.previousRefComponent.getContainer().getContainer() == this.parentModelGroup) {
            this.doInsertBefore = false;
        }
    }

    public boolean canMove() {
        boolean result = true;
        if (this.nextRefComponent instanceof XSDAttributeDeclaration || this.previousRefComponent instanceof XSDAttributeDeclaration || this.parentModelGroup == null) {
            return false;
        }
        return result;
    }

    public void run() {
        try {
            Iterator i = this.selectedComponentsList.iterator();
            while (i.hasNext()) {
                XSDConcreteComponent concreteComponent = (XSDConcreteComponent)i.next();
                if (this.doInsertBefore ? concreteComponent == this.nextRefComponent : concreteComponent == this.previousRefComponent) continue;
                Iterator particles = this.parentModelGroup.getContents().iterator();
                while (particles.hasNext()) {
                    XSDParticle particle = (XSDParticle)particles.next();
                    XSDParticleContent particleContent = particle.getContent();
                    if (particleContent != concreteComponent) continue;
                    this.parentModelGroup.getContents().remove((Object)particle);
                    break;
                }
                int index = 0;
                EList particles2 = this.parentModelGroup.getContents();
                Iterator iterator = particles2.iterator();
                while (iterator.hasNext()) {
                    XSDParticle particle = (XSDParticle)iterator.next();
                    XSDParticleContent particleContent = particle.getContent();
                    if (this.doInsertBefore) {
                        if (particleContent == this.nextRefComponent) {
                            this.parentModelGroup.getContents().add(index, (Object)concreteComponent.getContainer());
                            break;
                        }
                    } else if (particleContent == this.previousRefComponent) {
                        this.parentModelGroup.getContents().add(index + 1, (Object)concreteComponent.getContainer());
                        break;
                    }
                    ++index;
                }
                if (particles2.size() != 0) continue;
                this.parentModelGroup.getContents().add((Object)concreteComponent.getContainer());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

