/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;
import org.eclipse.uml2.uml.internal.operations.RegionOperations;

public class StateOperations
extends NamespaceOperations {
    protected StateOperations() {
    }

    public static boolean validateSubmachineStates(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateDestinationsOrSourcesOfTransitions(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateSubmachineOrRegions(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateCompositeStates(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateEntryOrExit(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean isSimple(State state) {
        return state.getRegions().isEmpty();
    }

    public static boolean isComposite(State state) {
        return !state.getRegions().isEmpty();
    }

    public static boolean isOrthogonal(State state) {
        return state.getRegions().size() > 1;
    }

    public static boolean isSubmachineState(State state) {
        return state.getSubmachine() != null;
    }

    public static Classifier redefinitionContext(State state) {
        StateMachine sm = state.containingStateMachine();
        if (sm != null) {
            BehavioredClassifier context = sm.getContext();
            return context == null || !sm.getGenerals().isEmpty() ? sm : context;
        }
        return null;
    }

    public static boolean isRedefinitionContextValid(State state, State redefined) {
        Region container;
        if (redefined != null && (container = state.getContainer()) != null) {
            return RegionOperations.getAllExtendedRegions(container).contains((Object)redefined.getContainer());
        }
        return false;
    }

    public static boolean isConsistentWith(State state, RedefinableElement redefinee) {
        if (redefinee != null && redefinee.isRedefinitionContextValid(state)) {
            State redefineeState = (State)redefinee;
            EList allRegions = StateOperations.getAllRegions(state);
            Iterator redefineeRegions = redefineeState.getRegions().iterator();
            while (redefineeRegions.hasNext()) {
                Region redefineeRegion = (Region)redefineeRegions.next();
                Region extendedRegion = redefineeRegion.getExtendedRegion();
                if (!allRegions.contains((Object)extendedRegion) || extendedRegion.isConsistentWith(redefineeRegion)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static StateMachine containingStateMachine(State state) {
        Region container = state.getContainer();
        return container == null ? null : container.containingStateMachine();
    }

    protected static EList getAllRedefinedStates(State state, EList allRedefinedStates) {
        State redefinedState = state.getRedefinedState();
        if (redefinedState != null && allRedefinedStates.add((Object)redefinedState)) {
            StateOperations.getAllRedefinedStates(redefinedState, allRedefinedStates);
        }
        return allRedefinedStates;
    }

    protected static EList getAllRedefinedStates(State state) {
        return StateOperations.getAllRedefinedStates(state, (EList)new UniqueEList.FastCompare());
    }

    protected static EList getAllRegions(State state) {
        UniqueEList.FastCompare allRegions = new UniqueEList.FastCompare((Collection)state.getRegions());
        Iterator allRedefinedStates = StateOperations.getAllRedefinedStates(state).iterator();
        while (allRedefinedStates.hasNext()) {
            allRegions.addAll((Collection)((State)((Object)allRedefinedStates)).getRegions());
        }
        return RedefinableElementOperations.excludeRedefinedElements((EList)allRegions);
    }
}

