/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.matcher;

import fr.jayasoft.ivy.matcher.AnyMatcher;
import fr.jayasoft.ivy.matcher.Matcher;
import fr.jayasoft.ivy.matcher.PatternMatcher;

public final class ExactPatternMatcher
implements PatternMatcher {
    private static final ExactPatternMatcher INSTANCE = new ExactPatternMatcher();

    public static PatternMatcher getInstance() {
        return INSTANCE;
    }

    private ExactPatternMatcher() {
    }

    public String getName() {
        return "exact";
    }

    public Matcher getMatcher(String exp) {
        if ("*".equals(exp)) {
            return AnyMatcher.getInstance();
        }
        return new ExactMatcher(exp);
    }

    public static class ExactMatcher
    implements Matcher {
        protected String _exp;

        public ExactMatcher(String exp) {
            this._exp = exp;
        }

        public boolean matches(String str) {
            return str == null ? this._exp == null : str.equals(this._exp);
        }

        public boolean isExact() {
            return true;
        }
    }
}

