/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xmlrpc.ServerInputStream;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlWriter;

public class XmlRpcClientLite
extends XmlRpcClient {
    static String auth;

    public XmlRpcClientLite(URL uRL) {
        super(uRL);
    }

    public XmlRpcClientLite(String string) throws MalformedURLException {
        super(string);
    }

    public XmlRpcClientLite(String string, int n) throws MalformedURLException {
        super(string, n);
    }

    synchronized XmlRpcClient.Worker getWorker(boolean bl) throws IOException {
        try {
            XmlRpcClient.Worker worker = (XmlRpcClient.Worker)this.pool.pop();
            if (bl) {
                ++this.asyncWorkers;
            } else {
                ++this.workers;
            }
            return worker;
        }
        catch (EmptyStackException emptyStackException) {
            if (this.workers < XmlRpc.getMaxThreads()) {
                if (bl) {
                    ++this.asyncWorkers;
                } else {
                    ++this.workers;
                }
                return new LiteWorker();
            }
            throw new IOException("XML-RPC System overload");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            XmlRpcClientLite xmlRpcClientLite = new XmlRpcClientLite(string);
            Vector<Object> vector = new Vector<Object>();
            for (int i = 2; i < stringArray.length; ++i) {
                try {
                    vector.addElement(new Integer(Integer.parseInt(stringArray[i])));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    vector.addElement(stringArray[i]);
                }
            }
            try {
                System.out.println(xmlRpcClientLite.execute(string2, vector));
            }
            catch (Exception exception) {
                System.err.println("Error: " + exception.getMessage());
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Usage: java org.apache.xmlrpc.XmlRpcClient <url> <method> <arg> ....");
            System.err.println("Arguments are sent as integers or strings.");
        }
    }

    class HttpClient {
        String hostname;
        String host;
        int port;
        String uri;
        Socket socket = null;
        BufferedOutputStream output;
        BufferedInputStream input;
        boolean keepalive;
        byte[] buffer;

        public HttpClient(URL uRL) throws IOException {
            this.hostname = uRL.getHost();
            this.port = uRL.getPort();
            if (this.port < 1) {
                this.port = 80;
            }
            this.uri = uRL.getFile();
            if (this.uri == null || "".equals(this.uri)) {
                this.uri = "/";
            }
            this.host = this.port == 80 ? this.hostname : this.hostname + ":" + this.port;
            this.initConnection();
        }

        protected void initConnection() throws IOException {
            this.socket = new Socket(this.hostname, this.port);
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            this.input = new BufferedInputStream(this.socket.getInputStream());
        }

        protected void closeConnection() {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public InputStream sendRequest(byte[] byArray) throws IOException {
            this.output.write(("POST " + this.uri + " HTTP/1.0\r\n").getBytes());
            this.output.write("User-Agent: Apache XML-RPC 1.2-a3-dev\r\n".getBytes());
            this.output.write(("Host: " + this.host + "\r\n").getBytes());
            if (XmlRpc.getKeepAlive()) {
                this.output.write("Connection: Keep-Alive\r\n".getBytes());
            }
            this.output.write("Content-Type: text/xml\r\n".getBytes());
            if (auth != null) {
                this.output.write(("Authorization: Basic " + auth + "\r\n").getBytes());
            }
            this.output.write(("Content-Length: " + byArray.length).getBytes());
            this.output.write("\r\n\r\n".getBytes());
            this.output.write(byArray);
            this.output.flush();
            String string = this.readLine();
            if (XmlRpc.debug) {
                System.out.println(string);
            }
            int n = -1;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken("\n\r");
                boolean bl = this.keepalive = XmlRpc.getKeepAlive() && "HTTP/1.1".equals(string2);
                if (!"200".equals(string3)) {
                    throw new IOException("Unexpected Response from Server: " + string4);
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("Server returned invalid Response.");
            }
            do {
                if ((string = this.readLine()) == null) continue;
                if (XmlRpc.debug) {
                    System.out.println(string);
                }
                if ((string = string.toLowerCase()).startsWith("content-length:")) {
                    n = Integer.parseInt(string.substring(15).trim());
                }
                if (!string.startsWith("connection:")) continue;
                boolean bl = this.keepalive = XmlRpc.getKeepAlive() && string.indexOf("keep-alive") > -1;
            } while (string != null && !string.equals(""));
            return new ServerInputStream(this.input, n);
        }

        private String readLine() throws IOException {
            int n;
            if (this.buffer == null) {
                this.buffer = new byte[2048];
            }
            int n2 = 0;
            while ((n = this.input.read()) >= 0 && n != 10) {
                if (n != 13) {
                    this.buffer[n2++] = (byte)n;
                }
                if (n2 < this.buffer.length) continue;
                throw new IOException("HTTP Header too long");
            }
            return new String(this.buffer, 0, n2);
        }

        protected void finalize() throws Throwable {
            this.closeConnection();
        }
    }

    class LiteWorker
    extends XmlRpcClient.Worker
    implements Runnable {
        HttpClient client = null;

        public LiteWorker() {
            super(XmlRpcClientLite.this);
        }

        Object execute(String string, Vector vector) throws XmlRpcException, IOException {
            Object object;
            Object object2;
            Object object3;
            long l = System.currentTimeMillis();
            this.fault = false;
            try {
                if (this.buffer == null) {
                    this.buffer = new ByteArrayOutputStream();
                } else {
                    this.buffer.reset();
                }
                object3 = new XmlWriter((OutputStream)this.buffer, encoding);
                this.writeRequest((XmlWriter)object3, string, vector);
                ((OutputStreamWriter)object3).flush();
                object2 = this.buffer.toByteArray();
                if (this.client == null) {
                    this.client = new HttpClient(XmlRpcClientLite.this.url);
                }
                object = null;
                try {
                    object = this.client.sendRequest((byte[])object2);
                }
                catch (IOException iOException) {
                    if (this.client.keepalive) {
                        this.client.closeConnection();
                        this.client.initConnection();
                        object = this.client.sendRequest((byte[])object2);
                    }
                    throw iOException;
                }
                this.parse((InputStream)object);
                if (!this.client.keepalive) {
                    this.client.closeConnection();
                    this.client = null;
                }
                if (debug) {
                    System.out.println("result = " + this.result);
                }
                if (this.errorLevel == 2) {
                    throw new Exception(this.errorMsg);
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                String string2;
                if (XmlRpc.debug) {
                    exception.printStackTrace();
                }
                if ((string2 = exception.getMessage()) == null || string2.length() == 0) {
                    string2 = exception.toString();
                }
                throw new IOException(string2);
            }
            if (this.fault) {
                object3 = null;
                try {
                    object2 = (Hashtable)this.result;
                    object = (String)((Hashtable)object2).get("faultString");
                    int n = Integer.parseInt(((Hashtable)object2).get("faultCode").toString());
                    object3 = new XmlRpcException(n, ((String)object).trim());
                }
                catch (Exception exception) {
                    throw new XmlRpcException(0, "Server returned an invalid fault response.");
                }
                throw object3;
            }
            if (debug) {
                System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis in request");
            }
            return this.result;
        }
    }
}

