/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsIWebBrowser;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.internal.mozilla.nsIWindowCreator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class WindowCreator {
    XPCOMObject supports;
    XPCOMObject windowCreator;
    int refCount = 0;

    public WindowCreator() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public long method0(long[] args) {
                return WindowCreator.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return WindowCreator.this.AddRef();
            }

            public long method2(long[] args) {
                return WindowCreator.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 3;
        this.windowCreator = new XPCOMObject(nArray2){

            public long method0(long[] args) {
                return WindowCreator.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return WindowCreator.this.AddRef();
            }

            public long method2(long[] args) {
                return WindowCreator.this.Release();
            }

            public long method3(long[] args) {
                return WindowCreator.this.CreateChromeWindow(args[0], args[1], args[2]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.windowCreator != null) {
            this.windowCreator.dispose();
            this.windowCreator = null;
        }
    }

    long getAddress() {
        return this.windowCreator.getAddress();
    }

    long QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262L;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.supports.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIWindowCreator.NS_IWINDOWCREATOR_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.windowCreator.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(ppvObject, new long[1], OS.PTR_SIZEOF);
        return -2147467262L;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    long CreateChromeWindow(long parent, long chromeFlags, long _retval) {
        Browser browser;
        long[] result;
        nsIWebBrowser webBrowser;
        if (parent == 0L) {
            return -2147467263L;
        }
        nsIWebBrowserChrome browserChromeParent = new nsIWebBrowserChrome(parent);
        long[] aWebBrowser = new long[1];
        int rc = browserChromeParent.GetWebBrowser(aWebBrowser);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (aWebBrowser[0] == 0L) {
            Browser.error(-2147467262);
        }
        if ((rc = (webBrowser = new nsIWebBrowser(aWebBrowser[0])).QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result = new long[1])) != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        webBrowser.Release();
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        result[0] = 0L;
        long[] aParentNativeWindow = new long[1];
        rc = baseWindow.GetParentNativeWindow(aParentNativeWindow);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (aParentNativeWindow[0] == 0L) {
            Browser.error(-2147467262);
        }
        baseWindow.Release();
        Display display = Display.getCurrent();
        Browser src = Browser.findBrowser(aParentNativeWindow[0]);
        boolean doit = false;
        if ((chromeFlags & 0x20000000L) != 0L) {
            final Shell shell = new Shell(src.getShell(), 67680);
            shell.setLayout(new FillLayout());
            browser = new Browser(shell, 0);
            browser.addVisibilityWindowListener(new VisibilityWindowListener(){

                public void hide(WindowEvent event) {
                }

                public void show(WindowEvent event) {
                    if (event.location != null) {
                        shell.setLocation(event.location);
                    }
                    if (event.size != null) {
                        Point size = event.size;
                        shell.setSize(shell.computeSize(size.x, size.y));
                    }
                    shell.open();
                }
            });
            browser.addCloseWindowListener(new CloseWindowListener(){

                public void close(WindowEvent event) {
                    shell.close();
                }
            });
            doit = true;
        } else {
            WindowEvent event = new WindowEvent(src);
            event.display = display;
            event.widget = src;
            event.required = true;
            int i = 0;
            while (i < src.openWindowListeners.length) {
                src.openWindowListeners[i].open(event);
                ++i;
            }
            browser = event.browser;
            boolean bl = doit = browser != null && !browser.isDisposed();
            if (doit) {
                browser.addressBar = (chromeFlags & 0x40L) != 0L;
                browser.menuBar = (chromeFlags & 0x10L) != 0L;
                browser.statusBar = (chromeFlags & 0x80L) != 0L;
                boolean bl2 = browser.toolBar = (chromeFlags & 0x20L) != 0L;
            }
        }
        if (doit) {
            long address = browser.webBrowserChrome.getAddress();
            nsIWebBrowserChrome webBrowserChrome = new nsIWebBrowserChrome(address);
            webBrowserChrome.AddRef();
            XPCOM.memmove(_retval, new long[]{address}, OS.PTR_SIZEOF);
        }
        return doit ? 0 : -2147467263;
    }
}

