/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinter;

import java.util.HashMap;
import java.util.Map;

public class PrettyPrinterPrefs {
    private String newLine;
    private String spacesBeforeComment = "";
    private Map<String, String> tokReplacement = new HashMap<String, String>();
    private int linesAfterMethod = 0;
    private int linesAfterClass = 0;
    private int spacesAfterColonInDict = 0;

    public PrettyPrinterPrefs(String newLine) {
        this.newLine = newLine;
        this.tokReplacement.put("elif", "elif ");
    }

    public String getNewLine() {
        return this.newLine;
    }

    public String getIndent() {
        return "    ";
    }

    public void setSpacesAfterComma(int i) {
        this.tokReplacement.put(",", this.createSpacesStr(i, ","));
    }

    private String createSpacesStr(int i, String startingWith) {
        StringBuffer buffer = new StringBuffer();
        if (startingWith != null) {
            buffer.append(startingWith);
        }
        int j = 0;
        while (j < i) {
            buffer.append(' ');
            ++j;
        }
        return buffer.toString();
    }

    public String getReplacement(String tok) {
        String r = this.tokReplacement.get(tok);
        if (r == null) {
            return tok;
        }
        return r;
    }

    public String getSpacesBeforeComment() {
        return this.spacesBeforeComment;
    }

    public void setSpacesBeforeComment(int i) {
        this.spacesBeforeComment = this.createSpacesStr(i, null);
    }

    public void setSpacesAfterColon(int i) {
        this.spacesAfterColonInDict = i;
    }

    public void enableSpacesAfterColon() {
        this.tokReplacement.put(":", this.createSpacesStr(this.spacesAfterColonInDict, ":"));
    }

    public void disableSpacesAfterColon() {
        this.tokReplacement.put(":", ":");
    }

    public void setLinesAfterMethod(int i) {
        this.linesAfterMethod = i;
    }

    public int getLinesAfterMethod() {
        return this.linesAfterMethod;
    }

    public void setLinesAfterClass(int i) {
        this.linesAfterClass = i;
    }

    public int getLinesAfterClass() {
        return this.linesAfterClass;
    }
}

