/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.plugin.PydevPlugin;

public class OutlineSortByNameAction
extends Action {
    private static final String PREF_ALPHA_SORT = "org.python.pydev.OUTLINE_ALPHA_SORT";
    ViewerSorter sortByNameSorter;
    private WeakReference<PyOutlinePage> page;

    public OutlineSortByNameAction(PyOutlinePage page, ImageCache imageCache) {
        super("Sort by name", 2);
        this.page = new WeakReference<PyOutlinePage>(page);
        this.setChecked(page.getStore().getBoolean(PREF_ALPHA_SORT));
        this.setAlphaSort(this.isChecked());
        try {
            this.setImageDescriptor(imageCache.getDescriptor("icons/alphab_sort_co.gif"));
        }
        catch (MalformedURLException e) {
            PydevPlugin.log("Missing Icon", e);
        }
        this.setToolTipText("Sort by name");
    }

    public void setAlphaSort(boolean doSort) {
        PyOutlinePage p = (PyOutlinePage)((Object)this.page.get());
        if (p != null) {
            p.getStore().setValue(PREF_ALPHA_SORT, doSort);
            if (this.sortByNameSorter == null) {
                this.sortByNameSorter = new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        return ((Comparable)e1).compareTo(e2);
                    }
                };
            }
            p.getTreeViewer().setSorter(doSort ? this.sortByNameSorter : null);
        }
    }

    public void run() {
        this.setAlphaSort(this.isChecked());
    }
}

