// This file is generated by TableGen. Do not edit.

#ifndef LLVM_CLANG_ATTR_CLASSES_INC
#define LLVM_CLANG_ATTR_CLASSES_INC

class AliasAttr : public InheritableAttr {
unsigned aliaseeLength;
char *aliasee;


 public:
  AliasAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Aliasee
             )
    : InheritableAttr(attr::Alias, L)
              , aliaseeLength(Aliasee.size()),aliasee(new (Ctx, 1) char[aliaseeLength])
  {
      std::memcpy(aliasee, Aliasee.data(), aliaseeLength);
  }

  virtual AliasAttr *clone (ASTContext &C) const;
  llvm::StringRef getAliasee() const {
    return llvm::StringRef(aliasee, aliaseeLength);
  }
  unsigned getAliaseeLength() const {
    return aliaseeLength;
  }
  void setAliasee(ASTContext &C, llvm::StringRef S) {
    aliaseeLength = S.size();
    this->aliasee = new (C, 1) char [aliaseeLength];
    std::memcpy(this->aliasee, S.data(), aliaseeLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Alias; }
  static bool classof(const AliasAttr *) { return true; }
};

class AlignMac68kAttr : public InheritableAttr {

 public:
  AlignMac68kAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::AlignMac68k, L)
  {
  }

  virtual AlignMac68kAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AlignMac68k; }
  static bool classof(const AlignMac68kAttr *) { return true; }
};

class AlignedAttr : public InheritableAttr {
bool isalignmentExpr;
union {
Expr *alignmentExpr;
TypeSourceInfo *alignmentType;
};


 public:
  AlignedAttr(SourceLocation L, ASTContext &Ctx
              , bool IsAlignmentExpr, void *Alignment
             )
    : InheritableAttr(attr::Aligned, L)
              , isalignmentExpr(IsAlignmentExpr)
  {
    if (isalignmentExpr)
       alignmentExpr = reinterpret_cast<Expr *>(Alignment);
    else
       alignmentType = reinterpret_cast<TypeSourceInfo *>(Alignment);
  }

  virtual AlignedAttr *clone (ASTContext &C) const;
  bool isAlignmentDependent() const;
  unsigned getAlignment(ASTContext &Ctx) const;
  bool isAlignmentExpr() const {
    return isalignmentExpr;
  }
  Expr *getAlignmentExpr() const {
    assert(isalignmentExpr);
    return alignmentExpr;
  }
  TypeSourceInfo *getAlignmentType() const {
    assert(!isalignmentExpr);
    return alignmentType;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Aligned; }
  static bool classof(const AlignedAttr *) { return true; }
};

class AlwaysInlineAttr : public InheritableAttr {

 public:
  AlwaysInlineAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::AlwaysInline, L)
  {
  }

  virtual AlwaysInlineAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AlwaysInline; }
  static bool classof(const AlwaysInlineAttr *) { return true; }
};

class AnalyzerNoReturnAttr : public InheritableAttr {

 public:
  AnalyzerNoReturnAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::AnalyzerNoReturn, L)
  {
  }

  virtual AnalyzerNoReturnAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AnalyzerNoReturn; }
  static bool classof(const AnalyzerNoReturnAttr *) { return true; }
};

class AnnotateAttr : public InheritableAttr {
unsigned annotationLength;
char *annotation;


 public:
  AnnotateAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Annotation
             )
    : InheritableAttr(attr::Annotate, L)
              , annotationLength(Annotation.size()),annotation(new (Ctx, 1) char[annotationLength])
  {
      std::memcpy(annotation, Annotation.data(), annotationLength);
  }

  virtual AnnotateAttr *clone (ASTContext &C) const;
  llvm::StringRef getAnnotation() const {
    return llvm::StringRef(annotation, annotationLength);
  }
  unsigned getAnnotationLength() const {
    return annotationLength;
  }
  void setAnnotation(ASTContext &C, llvm::StringRef S) {
    annotationLength = S.size();
    this->annotation = new (C, 1) char [annotationLength];
    std::memcpy(this->annotation, S.data(), annotationLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Annotate; }
  static bool classof(const AnnotateAttr *) { return true; }
};

class AsmLabelAttr : public InheritableAttr {
unsigned labelLength;
char *label;


 public:
  AsmLabelAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Label
             )
    : InheritableAttr(attr::AsmLabel, L)
              , labelLength(Label.size()),label(new (Ctx, 1) char[labelLength])
  {
      std::memcpy(label, Label.data(), labelLength);
  }

  virtual AsmLabelAttr *clone (ASTContext &C) const;
  llvm::StringRef getLabel() const {
    return llvm::StringRef(label, labelLength);
  }
  unsigned getLabelLength() const {
    return labelLength;
  }
  void setLabel(ASTContext &C, llvm::StringRef S) {
    labelLength = S.size();
    this->label = new (C, 1) char [labelLength];
    std::memcpy(this->label, S.data(), labelLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::AsmLabel; }
  static bool classof(const AsmLabelAttr *) { return true; }
};

class BlocksAttr : public InheritableAttr {
public:
  enum BlockType {
    ByRef
  };
private:
  BlockType type;


 public:
  BlocksAttr(SourceLocation L, ASTContext &Ctx
              , BlockType Type
             )
    : InheritableAttr(attr::Blocks, L)
              , type(Type)
  {

  }

  virtual BlocksAttr *clone (ASTContext &C) const;
  BlockType getType() const {
    return type;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Blocks; }
  static bool classof(const BlocksAttr *) { return true; }
};

class CDeclAttr : public InheritableAttr {

 public:
  CDeclAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::CDecl, L)
  {
  }

  virtual CDeclAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CDecl; }
  static bool classof(const CDeclAttr *) { return true; }
};

class CFConsumedAttr : public InheritableParamAttr {

 public:
  CFConsumedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableParamAttr(attr::CFConsumed, L)
  {
  }

  virtual CFConsumedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFConsumed; }
  static bool classof(const CFConsumedAttr *) { return true; }
};

class CFReturnsNotRetainedAttr : public InheritableAttr {

 public:
  CFReturnsNotRetainedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFReturnsNotRetained, L)
  {
  }

  virtual CFReturnsNotRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFReturnsNotRetained; }
  static bool classof(const CFReturnsNotRetainedAttr *) { return true; }
};

class CFReturnsRetainedAttr : public InheritableAttr {

 public:
  CFReturnsRetainedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFReturnsRetained, L)
  {
  }

  virtual CFReturnsRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFReturnsRetained; }
  static bool classof(const CFReturnsRetainedAttr *) { return true; }
};

class CUDAConstantAttr : public InheritableAttr {

 public:
  CUDAConstantAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAConstant, L)
  {
  }

  virtual CUDAConstantAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAConstant; }
  static bool classof(const CUDAConstantAttr *) { return true; }
};

class CUDADeviceAttr : public Attr {

 public:
  CUDADeviceAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::CUDADevice, L)
  {
  }

  virtual CUDADeviceAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDADevice; }
  static bool classof(const CUDADeviceAttr *) { return true; }
};

class CUDAGlobalAttr : public InheritableAttr {

 public:
  CUDAGlobalAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAGlobal, L)
  {
  }

  virtual CUDAGlobalAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAGlobal; }
  static bool classof(const CUDAGlobalAttr *) { return true; }
};

class CUDAHostAttr : public Attr {

 public:
  CUDAHostAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::CUDAHost, L)
  {
  }

  virtual CUDAHostAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAHost; }
  static bool classof(const CUDAHostAttr *) { return true; }
};

class CUDALaunchBoundsAttr : public InheritableAttr {
int maxThreads;

int minBlocks;


 public:
  CUDALaunchBoundsAttr(SourceLocation L, ASTContext &Ctx
              , int MaxThreads
              , int MinBlocks
             )
    : InheritableAttr(attr::CUDALaunchBounds, L)
              , maxThreads(MaxThreads)
              , minBlocks(MinBlocks)
  {


  }

  virtual CUDALaunchBoundsAttr *clone (ASTContext &C) const;
  int getMaxThreads() const {
    return maxThreads;
  }

  int getMinBlocks() const {
    return minBlocks;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::CUDALaunchBounds; }
  static bool classof(const CUDALaunchBoundsAttr *) { return true; }
};

class CUDASharedAttr : public InheritableAttr {

 public:
  CUDASharedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAShared, L)
  {
  }

  virtual CUDASharedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAShared; }
  static bool classof(const CUDASharedAttr *) { return true; }
};

class CarriesDependencyAttr : public InheritableParamAttr {

 public:
  CarriesDependencyAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableParamAttr(attr::CarriesDependency, L)
  {
  }

  virtual CarriesDependencyAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CarriesDependency; }
  static bool classof(const CarriesDependencyAttr *) { return true; }
};

class CleanupAttr : public InheritableAttr {
FunctionDecl * functionDecl;


 public:
  CleanupAttr(SourceLocation L, ASTContext &Ctx
              , FunctionDecl * FunctionDecl
             )
    : InheritableAttr(attr::Cleanup, L)
              , functionDecl(FunctionDecl)
  {

  }

  virtual CleanupAttr *clone (ASTContext &C) const;
  FunctionDecl * getFunctionDecl() const {
    return functionDecl;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Cleanup; }
  static bool classof(const CleanupAttr *) { return true; }
};

class CommonAttr : public InheritableAttr {

 public:
  CommonAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Common, L)
  {
  }

  virtual CommonAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Common; }
  static bool classof(const CommonAttr *) { return true; }
};

class ConstAttr : public InheritableAttr {

 public:
  ConstAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Const, L)
  {
  }

  virtual ConstAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Const; }
  static bool classof(const ConstAttr *) { return true; }
};

class ConstructorAttr : public InheritableAttr {
int priority;


 public:
  ConstructorAttr(SourceLocation L, ASTContext &Ctx
              , int Priority
             )
    : InheritableAttr(attr::Constructor, L)
              , priority(Priority)
  {

  }

  virtual ConstructorAttr *clone (ASTContext &C) const;
  int getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Constructor; }
  static bool classof(const ConstructorAttr *) { return true; }
};

class DLLExportAttr : public InheritableAttr {

 public:
  DLLExportAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::DLLExport, L)
  {
  }

  virtual DLLExportAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::DLLExport; }
  static bool classof(const DLLExportAttr *) { return true; }
};

class DLLImportAttr : public InheritableAttr {

 public:
  DLLImportAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::DLLImport, L)
  {
  }

  virtual DLLImportAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::DLLImport; }
  static bool classof(const DLLImportAttr *) { return true; }
};

class DeprecatedAttr : public InheritableAttr {
unsigned messageLength;
char *message;


 public:
  DeprecatedAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Message
             )
    : InheritableAttr(attr::Deprecated, L)
              , messageLength(Message.size()),message(new (Ctx, 1) char[messageLength])
  {
      std::memcpy(message, Message.data(), messageLength);
  }

  virtual DeprecatedAttr *clone (ASTContext &C) const;
  llvm::StringRef getMessage() const {
    return llvm::StringRef(message, messageLength);
  }
  unsigned getMessageLength() const {
    return messageLength;
  }
  void setMessage(ASTContext &C, llvm::StringRef S) {
    messageLength = S.size();
    this->message = new (C, 1) char [messageLength];
    std::memcpy(this->message, S.data(), messageLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Deprecated; }
  static bool classof(const DeprecatedAttr *) { return true; }
};

class DestructorAttr : public InheritableAttr {
int priority;


 public:
  DestructorAttr(SourceLocation L, ASTContext &Ctx
              , int Priority
             )
    : InheritableAttr(attr::Destructor, L)
              , priority(Priority)
  {

  }

  virtual DestructorAttr *clone (ASTContext &C) const;
  int getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Destructor; }
  static bool classof(const DestructorAttr *) { return true; }
};

class ExplicitAttr : public InheritableAttr {

 public:
  ExplicitAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Explicit, L)
  {
  }

  virtual ExplicitAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Explicit; }
  static bool classof(const ExplicitAttr *) { return true; }
};

class FastCallAttr : public InheritableAttr {

 public:
  FastCallAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::FastCall, L)
  {
  }

  virtual FastCallAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::FastCall; }
  static bool classof(const FastCallAttr *) { return true; }
};

class FinalAttr : public InheritableAttr {

 public:
  FinalAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Final, L)
  {
  }

  virtual FinalAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Final; }
  static bool classof(const FinalAttr *) { return true; }
};

class FormatAttr : public InheritableAttr {
unsigned typeLength;
char *type;

int formatIdx;

int firstArg;


 public:
  FormatAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Type
              , int FormatIdx
              , int FirstArg
             )
    : InheritableAttr(attr::Format, L)
              , typeLength(Type.size()),type(new (Ctx, 1) char[typeLength])
              , formatIdx(FormatIdx)
              , firstArg(FirstArg)
  {
      std::memcpy(type, Type.data(), typeLength);


  }

  virtual FormatAttr *clone (ASTContext &C) const;
  llvm::StringRef getType() const {
    return llvm::StringRef(type, typeLength);
  }
  unsigned getTypeLength() const {
    return typeLength;
  }
  void setType(ASTContext &C, llvm::StringRef S) {
    typeLength = S.size();
    this->type = new (C, 1) char [typeLength];
    std::memcpy(this->type, S.data(), typeLength);
  }

  int getFormatIdx() const {
    return formatIdx;
  }

  int getFirstArg() const {
    return firstArg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Format; }
  static bool classof(const FormatAttr *) { return true; }
};

class FormatArgAttr : public InheritableAttr {
int formatIdx;


 public:
  FormatArgAttr(SourceLocation L, ASTContext &Ctx
              , int FormatIdx
             )
    : InheritableAttr(attr::FormatArg, L)
              , formatIdx(FormatIdx)
  {

  }

  virtual FormatArgAttr *clone (ASTContext &C) const;
  int getFormatIdx() const {
    return formatIdx;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::FormatArg; }
  static bool classof(const FormatArgAttr *) { return true; }
};

class GNUInlineAttr : public InheritableAttr {

 public:
  GNUInlineAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::GNUInline, L)
  {
  }

  virtual GNUInlineAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::GNUInline; }
  static bool classof(const GNUInlineAttr *) { return true; }
};

class IBActionAttr : public InheritableAttr {

 public:
  IBActionAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::IBAction, L)
  {
  }

  virtual IBActionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::IBAction; }
  static bool classof(const IBActionAttr *) { return true; }
};

class IBOutletAttr : public InheritableAttr {

 public:
  IBOutletAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::IBOutlet, L)
  {
  }

  virtual IBOutletAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::IBOutlet; }
  static bool classof(const IBOutletAttr *) { return true; }
};

class IBOutletCollectionAttr : public InheritableAttr {
QualType interFace;


 public:
  IBOutletCollectionAttr(SourceLocation L, ASTContext &Ctx
              , QualType InterFace
             )
    : InheritableAttr(attr::IBOutletCollection, L)
              , interFace(InterFace)
  {

  }

  virtual IBOutletCollectionAttr *clone (ASTContext &C) const;
  QualType getInterFace() const {
    return interFace;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::IBOutletCollection; }
  static bool classof(const IBOutletCollectionAttr *) { return true; }
};

class InitPriorityAttr : public InheritableAttr {
unsigned priority;


 public:
  InitPriorityAttr(SourceLocation L, ASTContext &Ctx
              , unsigned Priority
             )
    : InheritableAttr(attr::InitPriority, L)
              , priority(Priority)
  {

  }

  virtual InitPriorityAttr *clone (ASTContext &C) const;
  unsigned getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::InitPriority; }
  static bool classof(const InitPriorityAttr *) { return true; }
};

class MBlazeInterruptHandlerAttr : public InheritableAttr {

 public:
  MBlazeInterruptHandlerAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::MBlazeInterruptHandler, L)
  {
  }

  virtual MBlazeInterruptHandlerAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MBlazeInterruptHandler; }
  static bool classof(const MBlazeInterruptHandlerAttr *) { return true; }
};

class MBlazeSaveVolatilesAttr : public InheritableAttr {

 public:
  MBlazeSaveVolatilesAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::MBlazeSaveVolatiles, L)
  {
  }

  virtual MBlazeSaveVolatilesAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MBlazeSaveVolatiles; }
  static bool classof(const MBlazeSaveVolatilesAttr *) { return true; }
};

class MSP430InterruptAttr : public InheritableAttr {
unsigned number;


 public:
  MSP430InterruptAttr(SourceLocation L, ASTContext &Ctx
              , unsigned Number
             )
    : InheritableAttr(attr::MSP430Interrupt, L)
              , number(Number)
  {

  }

  virtual MSP430InterruptAttr *clone (ASTContext &C) const;
  unsigned getNumber() const {
    return number;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::MSP430Interrupt; }
  static bool classof(const MSP430InterruptAttr *) { return true; }
};

class MallocAttr : public InheritableAttr {

 public:
  MallocAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Malloc, L)
  {
  }

  virtual MallocAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Malloc; }
  static bool classof(const MallocAttr *) { return true; }
};

class MaxFieldAlignmentAttr : public InheritableAttr {
unsigned alignment;


 public:
  MaxFieldAlignmentAttr(SourceLocation L, ASTContext &Ctx
              , unsigned Alignment
             )
    : InheritableAttr(attr::MaxFieldAlignment, L)
              , alignment(Alignment)
  {

  }

  virtual MaxFieldAlignmentAttr *clone (ASTContext &C) const;
  unsigned getAlignment() const {
    return alignment;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::MaxFieldAlignment; }
  static bool classof(const MaxFieldAlignmentAttr *) { return true; }
};

class MayAliasAttr : public InheritableAttr {

 public:
  MayAliasAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::MayAlias, L)
  {
  }

  virtual MayAliasAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MayAlias; }
  static bool classof(const MayAliasAttr *) { return true; }
};

class NSConsumedAttr : public InheritableParamAttr {

 public:
  NSConsumedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableParamAttr(attr::NSConsumed, L)
  {
  }

  virtual NSConsumedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSConsumed; }
  static bool classof(const NSConsumedAttr *) { return true; }
};

class NSConsumesSelfAttr : public InheritableAttr {

 public:
  NSConsumesSelfAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSConsumesSelf, L)
  {
  }

  virtual NSConsumesSelfAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSConsumesSelf; }
  static bool classof(const NSConsumesSelfAttr *) { return true; }
};

class NSReturnsAutoreleasedAttr : public InheritableAttr {

 public:
  NSReturnsAutoreleasedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSReturnsAutoreleased, L)
  {
  }

  virtual NSReturnsAutoreleasedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsAutoreleased; }
  static bool classof(const NSReturnsAutoreleasedAttr *) { return true; }
};

class NSReturnsNotRetainedAttr : public InheritableAttr {

 public:
  NSReturnsNotRetainedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSReturnsNotRetained, L)
  {
  }

  virtual NSReturnsNotRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsNotRetained; }
  static bool classof(const NSReturnsNotRetainedAttr *) { return true; }
};

class NSReturnsRetainedAttr : public InheritableAttr {

 public:
  NSReturnsRetainedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSReturnsRetained, L)
  {
  }

  virtual NSReturnsRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsRetained; }
  static bool classof(const NSReturnsRetainedAttr *) { return true; }
};

class NakedAttr : public InheritableAttr {

 public:
  NakedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Naked, L)
  {
  }

  virtual NakedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Naked; }
  static bool classof(const NakedAttr *) { return true; }
};

class NoCommonAttr : public InheritableAttr {

 public:
  NoCommonAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoCommon, L)
  {
  }

  virtual NoCommonAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoCommon; }
  static bool classof(const NoCommonAttr *) { return true; }
};

class NoDebugAttr : public InheritableAttr {

 public:
  NoDebugAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoDebug, L)
  {
  }

  virtual NoDebugAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoDebug; }
  static bool classof(const NoDebugAttr *) { return true; }
};

class NoInlineAttr : public InheritableAttr {

 public:
  NoInlineAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoInline, L)
  {
  }

  virtual NoInlineAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoInline; }
  static bool classof(const NoInlineAttr *) { return true; }
};

class NoInstrumentFunctionAttr : public InheritableAttr {

 public:
  NoInstrumentFunctionAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoInstrumentFunction, L)
  {
  }

  virtual NoInstrumentFunctionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoInstrumentFunction; }
  static bool classof(const NoInstrumentFunctionAttr *) { return true; }
};

class NoReturnAttr : public InheritableAttr {

 public:
  NoReturnAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoReturn, L)
  {
  }

  virtual NoReturnAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoReturn; }
  static bool classof(const NoReturnAttr *) { return true; }
};

class NoThrowAttr : public InheritableAttr {

 public:
  NoThrowAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoThrow, L)
  {
  }

  virtual NoThrowAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoThrow; }
  static bool classof(const NoThrowAttr *) { return true; }
};

class NonNullAttr : public InheritableAttr {
  unsigned argsSize;
  unsigned *args;


 public:
  NonNullAttr(SourceLocation L, ASTContext &Ctx
              , unsigned *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::NonNull, L)
              , argsSize(ArgsSize), args(new (Ctx, 16) unsigned[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(unsigned));

  }

  virtual NonNullAttr *clone (ASTContext &C) const;
  typedef unsigned* args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }

bool isNonNull(unsigned idx) const {
    for (args_iterator i = args_begin(), e = args_end();
         i != e; ++i)
      if (*i == idx)
        return true;
    return false;
  } 

  static bool classof(const Attr *A) { return A->getKind() == attr::NonNull; }
  static bool classof(const NonNullAttr *) { return true; }
};

class ObjCExceptionAttr : public InheritableAttr {

 public:
  ObjCExceptionAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::ObjCException, L)
  {
  }

  virtual ObjCExceptionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCException; }
  static bool classof(const ObjCExceptionAttr *) { return true; }
};

class ObjCMethodFamilyAttr : public InheritableAttr {
public:
  enum FamilyKind {
    OMF_None,
    OMF_alloc,
    OMF_copy,
    OMF_init,
    OMF_mutableCopy,
    OMF_new
  };
private:
  FamilyKind family;


 public:
  ObjCMethodFamilyAttr(SourceLocation L, ASTContext &Ctx
              , FamilyKind Family
             )
    : InheritableAttr(attr::ObjCMethodFamily, L)
              , family(Family)
  {

  }

  virtual ObjCMethodFamilyAttr *clone (ASTContext &C) const;
  FamilyKind getFamily() const {
    return family;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCMethodFamily; }
  static bool classof(const ObjCMethodFamilyAttr *) { return true; }
};

class ObjCNSObjectAttr : public InheritableAttr {

 public:
  ObjCNSObjectAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::ObjCNSObject, L)
  {
  }

  virtual ObjCNSObjectAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCNSObject; }
  static bool classof(const ObjCNSObjectAttr *) { return true; }
};

class OpenCLKernelAttr : public Attr {

 public:
  OpenCLKernelAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::OpenCLKernel, L)
  {
  }

  virtual OpenCLKernelAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::OpenCLKernel; }
  static bool classof(const OpenCLKernelAttr *) { return true; }
};

class OverloadableAttr : public Attr {

 public:
  OverloadableAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Overloadable, L)
  {
  }

  virtual OverloadableAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Overloadable; }
  static bool classof(const OverloadableAttr *) { return true; }
};

class OverrideAttr : public InheritableAttr {

 public:
  OverrideAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Override, L)
  {
  }

  virtual OverrideAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Override; }
  static bool classof(const OverrideAttr *) { return true; }
};

class OwnershipAttr : public InheritableAttr {
public:
  enum OwnershipKind {
    Holds,
    Returns,
    Takes
  };
private:
  OwnershipKind ownKind;

unsigned moduleLength;
char *module;

  unsigned argsSize;
  unsigned *args;


 public:
  OwnershipAttr(SourceLocation L, ASTContext &Ctx
              , OwnershipKind OwnKind
              , llvm::StringRef Module
              , unsigned *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::Ownership, L)
              , ownKind(OwnKind)
              , moduleLength(Module.size()),module(new (Ctx, 1) char[moduleLength])
              , argsSize(ArgsSize), args(new (Ctx, 16) unsigned[argsSize])
  {

      std::memcpy(module, Module.data(), moduleLength);
    std::memcpy(args, Args, argsSize * sizeof(unsigned));

  }

  virtual OwnershipAttr *clone (ASTContext &C) const;
  OwnershipKind getOwnKind() const {
    return ownKind;
  }

  llvm::StringRef getModule() const {
    return llvm::StringRef(module, moduleLength);
  }
  unsigned getModuleLength() const {
    return moduleLength;
  }
  void setModule(ASTContext &C, llvm::StringRef S) {
    moduleLength = S.size();
    this->module = new (C, 1) char [moduleLength];
    std::memcpy(this->module, S.data(), moduleLength);
  }

  typedef unsigned* args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Ownership; }
  static bool classof(const OwnershipAttr *) { return true; }
};

class PackedAttr : public InheritableAttr {

 public:
  PackedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Packed, L)
  {
  }

  virtual PackedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Packed; }
  static bool classof(const PackedAttr *) { return true; }
};

class PascalAttr : public InheritableAttr {

 public:
  PascalAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Pascal, L)
  {
  }

  virtual PascalAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Pascal; }
  static bool classof(const PascalAttr *) { return true; }
};

class PureAttr : public InheritableAttr {

 public:
  PureAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Pure, L)
  {
  }

  virtual PureAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Pure; }
  static bool classof(const PureAttr *) { return true; }
};

class RegparmAttr : public InheritableAttr {
unsigned numParams;


 public:
  RegparmAttr(SourceLocation L, ASTContext &Ctx
              , unsigned NumParams
             )
    : InheritableAttr(attr::Regparm, L)
              , numParams(NumParams)
  {

  }

  virtual RegparmAttr *clone (ASTContext &C) const;
  unsigned getNumParams() const {
    return numParams;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Regparm; }
  static bool classof(const RegparmAttr *) { return true; }
};

class ReqdWorkGroupSizeAttr : public InheritableAttr {
unsigned xDim;

unsigned yDim;

unsigned zDim;


 public:
  ReqdWorkGroupSizeAttr(SourceLocation L, ASTContext &Ctx
              , unsigned XDim
              , unsigned YDim
              , unsigned ZDim
             )
    : InheritableAttr(attr::ReqdWorkGroupSize, L)
              , xDim(XDim)
              , yDim(YDim)
              , zDim(ZDim)
  {



  }

  virtual ReqdWorkGroupSizeAttr *clone (ASTContext &C) const;
  unsigned getXDim() const {
    return xDim;
  }

  unsigned getYDim() const {
    return yDim;
  }

  unsigned getZDim() const {
    return zDim;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ReqdWorkGroupSize; }
  static bool classof(const ReqdWorkGroupSizeAttr *) { return true; }
};

class SectionAttr : public InheritableAttr {
unsigned nameLength;
char *name;


 public:
  SectionAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Name
             )
    : InheritableAttr(attr::Section, L)
              , nameLength(Name.size()),name(new (Ctx, 1) char[nameLength])
  {
      std::memcpy(name, Name.data(), nameLength);
  }

  virtual SectionAttr *clone (ASTContext &C) const;
  llvm::StringRef getName() const {
    return llvm::StringRef(name, nameLength);
  }
  unsigned getNameLength() const {
    return nameLength;
  }
  void setName(ASTContext &C, llvm::StringRef S) {
    nameLength = S.size();
    this->name = new (C, 1) char [nameLength];
    std::memcpy(this->name, S.data(), nameLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Section; }
  static bool classof(const SectionAttr *) { return true; }
};

class SentinelAttr : public InheritableAttr {
int sentinel;

int nullPos;


 public:
  SentinelAttr(SourceLocation L, ASTContext &Ctx
              , int Sentinel
              , int NullPos
             )
    : InheritableAttr(attr::Sentinel, L)
              , sentinel(Sentinel)
              , nullPos(NullPos)
  {


  }

  virtual SentinelAttr *clone (ASTContext &C) const;
  int getSentinel() const {
    return sentinel;
  }

  int getNullPos() const {
    return nullPos;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Sentinel; }
  static bool classof(const SentinelAttr *) { return true; }
};

class StdCallAttr : public InheritableAttr {

 public:
  StdCallAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::StdCall, L)
  {
  }

  virtual StdCallAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::StdCall; }
  static bool classof(const StdCallAttr *) { return true; }
};

class ThisCallAttr : public InheritableAttr {

 public:
  ThisCallAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::ThisCall, L)
  {
  }

  virtual ThisCallAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ThisCall; }
  static bool classof(const ThisCallAttr *) { return true; }
};

class TransparentUnionAttr : public InheritableAttr {

 public:
  TransparentUnionAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::TransparentUnion, L)
  {
  }

  virtual TransparentUnionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::TransparentUnion; }
  static bool classof(const TransparentUnionAttr *) { return true; }
};

class UnavailableAttr : public InheritableAttr {
unsigned messageLength;
char *message;


 public:
  UnavailableAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Message
             )
    : InheritableAttr(attr::Unavailable, L)
              , messageLength(Message.size()),message(new (Ctx, 1) char[messageLength])
  {
      std::memcpy(message, Message.data(), messageLength);
  }

  virtual UnavailableAttr *clone (ASTContext &C) const;
  llvm::StringRef getMessage() const {
    return llvm::StringRef(message, messageLength);
  }
  unsigned getMessageLength() const {
    return messageLength;
  }
  void setMessage(ASTContext &C, llvm::StringRef S) {
    messageLength = S.size();
    this->message = new (C, 1) char [messageLength];
    std::memcpy(this->message, S.data(), messageLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Unavailable; }
  static bool classof(const UnavailableAttr *) { return true; }
};

class UnusedAttr : public InheritableAttr {

 public:
  UnusedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Unused, L)
  {
  }

  virtual UnusedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Unused; }
  static bool classof(const UnusedAttr *) { return true; }
};

class UsedAttr : public InheritableAttr {

 public:
  UsedAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Used, L)
  {
  }

  virtual UsedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Used; }
  static bool classof(const UsedAttr *) { return true; }
};

class UuidAttr : public InheritableAttr {
unsigned guidLength;
char *guid;


 public:
  UuidAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Guid
             )
    : InheritableAttr(attr::Uuid, L)
              , guidLength(Guid.size()),guid(new (Ctx, 1) char[guidLength])
  {
      std::memcpy(guid, Guid.data(), guidLength);
  }

  virtual UuidAttr *clone (ASTContext &C) const;
  llvm::StringRef getGuid() const {
    return llvm::StringRef(guid, guidLength);
  }
  unsigned getGuidLength() const {
    return guidLength;
  }
  void setGuid(ASTContext &C, llvm::StringRef S) {
    guidLength = S.size();
    this->guid = new (C, 1) char [guidLength];
    std::memcpy(this->guid, S.data(), guidLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Uuid; }
  static bool classof(const UuidAttr *) { return true; }
};

class VecReturnAttr : public InheritableAttr {

 public:
  VecReturnAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::VecReturn, L)
  {
  }

  virtual VecReturnAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::VecReturn; }
  static bool classof(const VecReturnAttr *) { return true; }
};

class VisibilityAttr : public InheritableAttr {
public:
  enum VisibilityType {
    Default,
    Hidden,
    Protected
  };
private:
  VisibilityType visibility;


 public:
  VisibilityAttr(SourceLocation L, ASTContext &Ctx
              , VisibilityType Visibility
             )
    : InheritableAttr(attr::Visibility, L)
              , visibility(Visibility)
  {

  }

  virtual VisibilityAttr *clone (ASTContext &C) const;
  VisibilityType getVisibility() const {
    return visibility;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Visibility; }
  static bool classof(const VisibilityAttr *) { return true; }
};

class WarnUnusedResultAttr : public InheritableAttr {

 public:
  WarnUnusedResultAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::WarnUnusedResult, L)
  {
  }

  virtual WarnUnusedResultAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WarnUnusedResult; }
  static bool classof(const WarnUnusedResultAttr *) { return true; }
};

class WeakAttr : public InheritableAttr {

 public:
  WeakAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::Weak, L)
  {
  }

  virtual WeakAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Weak; }
  static bool classof(const WeakAttr *) { return true; }
};

class WeakImportAttr : public InheritableAttr {

 public:
  WeakImportAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::WeakImport, L)
  {
  }

  virtual WeakImportAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WeakImport; }
  static bool classof(const WeakImportAttr *) { return true; }
};

class WeakRefAttr : public InheritableAttr {

 public:
  WeakRefAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::WeakRef, L)
  {
  }

  virtual WeakRefAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WeakRef; }
  static bool classof(const WeakRefAttr *) { return true; }
};

class X86ForceAlignArgPointerAttr : public InheritableAttr {

 public:
  X86ForceAlignArgPointerAttr(SourceLocation L, ASTContext &Ctx
             )
    : InheritableAttr(attr::X86ForceAlignArgPointer, L)
  {
  }

  virtual X86ForceAlignArgPointerAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::X86ForceAlignArgPointer; }
  static bool classof(const X86ForceAlignArgPointerAttr *) { return true; }
};

#endif
