/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopIconUI;

public class BasicDesktopIconUI
extends DesktopIconUI {
    private static final int iconSize = 16;
    private static final int iconWidth = 160;
    private static final int iconHeight = 35;
    static Icon defaultIcon = new InternalFrameDefaultMenuIcon();
    protected JInternalFrame.JDesktopIcon desktopIcon;
    protected JInternalFrame frame;
    private transient MouseInputListener mouseHandler;
    transient BoundButton button;
    private transient PropertyChangeListener propertyHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopIconUI();
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JInternalFrame.JDesktopIcon) {
            this.desktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
            this.desktopIcon.setLayout(new BorderLayout());
            this.frame = this.desktopIcon.getInternalFrame();
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.desktopIcon.setOpaque(true);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.desktopIcon.setOpaque(false);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.frame = null;
        this.desktopIcon.setLayout(null);
        this.desktopIcon = null;
    }

    protected void installComponents() {
        this.button = new BoundButton(this.frame.getTitle());
        this.button.setHorizontalAlignment(2);
        this.button.setHorizontalTextPosition(11);
        Icon icon = this.frame.getFrameIcon();
        if (icon == null) {
            icon = defaultIcon;
        }
        this.button.setIcon(icon);
        this.desktopIcon.add((Component)this.button, 0);
    }

    protected void uninstallComponents() {
        this.desktopIcon.remove(this.button);
        this.button = null;
    }

    protected void installListeners() {
        this.mouseHandler = this.createMouseInputListener();
        this.desktopIcon.addMouseMotionListener(this.mouseHandler);
        this.desktopIcon.addMouseListener(this.mouseHandler);
        this.propertyHandler = new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("title")) {
                    BasicDesktopIconUI.this.button.setText(BasicDesktopIconUI.this.desktopIcon.getInternalFrame().getTitle());
                } else if (propertyChangeEvent.getPropertyName().equals("frameIcon")) {
                    Icon icon = BasicDesktopIconUI.this.desktopIcon.getInternalFrame().getFrameIcon();
                    if (icon == null) {
                        icon = defaultIcon;
                    }
                    BasicDesktopIconUI.this.button.setIcon(icon);
                }
                BasicDesktopIconUI.this.desktopIcon.revalidate();
                BasicDesktopIconUI.this.desktopIcon.repaint();
            }
        };
        this.frame.addPropertyChangeListener(this.propertyHandler);
        this.button.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                BasicDesktopIconUI.this.deiconize();
            }
        });
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyHandler);
        this.propertyHandler = null;
        this.desktopIcon.removeMouseMotionListener(this.mouseHandler);
        this.desktopIcon.removeMouseListener(this.mouseHandler);
    }

    protected void installDefaults() {
        this.desktopIcon.setBorder(new DesktopIconBorder());
    }

    protected void uninstallDefaults() {
        this.desktopIcon.setBorder(null);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(160, 35);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Insets getInsets(JComponent jComponent) {
        return jComponent.getInsets();
    }

    public void deiconize() {
        try {
            this.frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    static /* synthetic */ int access$0() {
        return 16;
    }

    static /* synthetic */ int access$1() {
        return 160;
    }

    static /* synthetic */ int access$2() {
        return 35;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BoundButton
    extends JButton {
        public Dimension getPreferredSize() {
            Insets insets = BasicDesktopIconUI.this.desktopIcon.getInsets();
            return new Dimension(160 - insets.left - insets.right, 35 - insets.top - insets.bottom);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public BoundButton(String string) {
            super(string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DesktopIconBorder
    implements Border {
        int left;
        int top;
        int right;
        int bottom;

        public Insets getBorderInsets(Component component) {
            return new Insets(this.top, this.left, this.bottom, this.right);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.fillRect(0, 0, this.left, n4);
            graphics.fillRect(0, 0, n3, this.top);
            graphics.fillRect(0, n4 - this.bottom, n3, this.bottom);
            graphics.fillRect(n3 - this.right, 0, this.right, n4);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            int n5 = n4 / 4;
            int n6 = this.left / 2;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(n6, n5, 2, 2);
            graphics.fillRect(n6, n5 * 2, 2, 2);
            graphics.fillRect(n6, n5 * 3, 2, 2);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        private final /* synthetic */ void this() {
            this.left = 10;
            this.right = this.top = 4;
            this.bottom = this.top;
        }

        private DesktopIconBorder() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseInputHandler
    extends MouseInputAdapter {
        private transient int xOffset;
        private transient int yOffset;
        private transient JDesktopPane pane;

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle = BasicDesktopIconUI.this.desktopIcon.getBounds();
            this.moveAndRepaint(BasicDesktopIconUI.this.desktopIcon, rectangle.x + mouseEvent.getX() - this.xOffset, rectangle.y + mouseEvent.getY() - this.yOffset, rectangle.width, rectangle.height);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.xOffset = mouseEvent.getX();
            this.yOffset = mouseEvent.getY();
            this.pane = BasicDesktopIconUI.this.frame.getDesktopPane();
            if (this.pane != null) {
                this.pane.getDesktopManager().beginDraggingFrame(BasicDesktopIconUI.this.desktopIcon);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.pane != null) {
                this.pane.getDesktopManager().endDraggingFrame(BasicDesktopIconUI.this.desktopIcon);
            }
            this.xOffset = 0;
            this.yOffset = 0;
        }

        public void moveAndRepaint(JComponent jComponent, int n, int n2, int n3, int n4) {
            if (this.pane != null) {
                this.pane.getDesktopManager().dragFrame(jComponent, n, n2);
            } else {
                BasicDesktopIconUI.this.desktopIcon.setBounds(n, n2, n3, n4);
            }
        }
    }

    static class InternalFrameDefaultMenuIcon
    implements Icon {
        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            graphics.setColor(Color.BLUE);
            graphics.fillRect(0, 0, 16, 6);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 5, 16, 13);
            graphics.setColor(Color.GRAY);
            graphics.drawRect(0, 0, 16, 16);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        InternalFrameDefaultMenuIcon() {
        }
    }
}

