/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

final class UTF_16Decoder
extends CharsetDecoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    static final int UNKNOWN_ENDIAN = 2;
    static final int MAYBE_BIG_ENDIAN = 3;
    static final int MAYBE_LITTLE_ENDIAN = 4;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final char REVERSED_BYTE_ORDER_MARK = '\ufffe';
    private final int originalByteOrder;
    private int byteOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block18: {
            CoderResult coderResult2;
            block24: {
                CoderResult coderResult3;
                block23: {
                    CoderResult coderResult4;
                    block22: {
                        CoderResult coderResult5;
                        block21: {
                            CoderResult coderResult6;
                            block20: {
                                CoderResult coderResult7;
                                n = byteBuffer.position();
                                try {
                                    while (true) {
                                        char c;
                                        if (byteBuffer.remaining() < 2) {
                                            coderResult = CoderResult.UNDERFLOW;
                                            break block18;
                                        }
                                        byte by = byteBuffer.get();
                                        byte by2 = byteBuffer.get();
                                        if (this.byteOrder == 2 || this.byteOrder == 3 || this.byteOrder == 4) {
                                            c = (char)((by & 0xFF) << 8 | by2 & 0xFF);
                                            if (c == '\ufeff') {
                                                if (this.byteOrder == 4) {
                                                    coderResult7 = CoderResult.malformedForLength(2);
                                                    Object var5_17 = null;
                                                    break;
                                                } else {
                                                    this.byteOrder = 0;
                                                    n += 2;
                                                    continue;
                                                }
                                            }
                                            if (c == '\ufffe') {
                                                if (this.byteOrder == 3) {
                                                    coderResult6 = CoderResult.malformedForLength(2);
                                                    break block20;
                                                } else {
                                                    this.byteOrder = 1;
                                                    n += 2;
                                                    continue;
                                                }
                                            }
                                            int n2 = 0;
                                            if (this.byteOrder == 4) {
                                                n2 = 1;
                                            }
                                            this.byteOrder = n2;
                                        }
                                        char c2 = c = this.byteOrder == 0 ? (char)((by & 0xFF) << 8 | by2 & 0xFF) : (char)((by2 & 0xFF) << 8 | by & 0xFF);
                                        if ('\ud800' <= c && c <= '\udfff') {
                                            char c3;
                                            if (c > '\udbff') {
                                                coderResult5 = CoderResult.malformedForLength(2);
                                                break block21;
                                            }
                                            if (byteBuffer.remaining() < 2) {
                                                coderResult4 = CoderResult.UNDERFLOW;
                                                break block22;
                                            }
                                            byte by3 = byteBuffer.get();
                                            byte by4 = byteBuffer.get();
                                            char c4 = c3 = this.byteOrder == 0 ? (char)((by3 & 0xFF) << 8 | by4 & 0xFF) : (char)((by4 & 0xFF) << 8 | by3 & 0xFF);
                                            if (c3 < '\udc00' || c3 > '\udfff') {
                                                coderResult3 = CoderResult.malformedForLength(2);
                                                break block23;
                                            } else {
                                                charBuffer.put(c);
                                                charBuffer.put(c3);
                                                n += 4;
                                                continue;
                                            }
                                        }
                                        if (!charBuffer.hasRemaining()) {
                                            coderResult2 = CoderResult.UNDERFLOW;
                                            break block24;
                                        }
                                        charBuffer.put(c);
                                        n += 2;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var5_24 = null;
                                    byteBuffer.position(n);
                                    throw throwable;
                                }
                                byteBuffer.position(n);
                                return coderResult7;
                            }
                            Object var5_18 = null;
                            byteBuffer.position(n);
                            return coderResult6;
                        }
                        Object var5_19 = null;
                        byteBuffer.position(n);
                        return coderResult5;
                    }
                    Object var5_20 = null;
                    byteBuffer.position(n);
                    return coderResult4;
                }
                Object var5_21 = null;
                byteBuffer.position(n);
                return coderResult3;
            }
            Object var5_22 = null;
            byteBuffer.position(n);
            return coderResult2;
        }
        Object var5_23 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    protected final void implReset() {
        this.byteOrder = this.originalByteOrder;
    }

    UTF_16Decoder(Charset charset, int n) {
        super(charset, 0.5f, 1.0f);
        this.originalByteOrder = n;
        this.byteOrder = n;
    }
}

