/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.introspector;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtils {
    private final Map<Class<?>, Map<String, Property>> propertiesCache = new HashMap();
    private final Map<Class<?>, Set<Property>> readableProperties = new HashMap();
    private BeanAccess beanAccess = BeanAccess.DEFAULT;
    private boolean allowReadOnlyProperties = false;

    protected Map<String, Property> getPropertiesMap(Class<?> type2, BeanAccess bAccess) throws IntrospectionException {
        if (this.propertiesCache.containsKey(type2)) {
            return this.propertiesCache.get(type2);
        }
        LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
        switch (bAccess) {
            case FIELD: {
                for (Class<?> c = type2; c != null; c = c.getSuperclass()) {
                    for (Field field2 : c.getDeclaredFields()) {
                        int modifiers2 = field2.getModifiers();
                        if (Modifier.isStatic(modifiers2) || Modifier.isTransient(modifiers2) || properties.containsKey(field2.getName())) continue;
                        properties.put(field2.getName(), new FieldProperty(field2));
                    }
                }
                break;
            }
            default: {
                for (PropertyDescriptor property : Introspector.getBeanInfo(type2).getPropertyDescriptors()) {
                    Method readMethod = property.getReadMethod();
                    if (readMethod != null && readMethod.getName().equals("getClass")) continue;
                    properties.put(property.getName(), new MethodProperty(property));
                }
                for (Field field3 : type2.getFields()) {
                    int modifiers3 = field3.getModifiers();
                    if (Modifier.isStatic(modifiers3) || Modifier.isTransient(modifiers3)) continue;
                    properties.put(field3.getName(), new FieldProperty(field3));
                }
            }
        }
        if (properties.isEmpty()) {
            throw new YAMLException("No JavaBean properties found in " + type2.getName());
        }
        this.propertiesCache.put(type2, properties);
        return properties;
    }

    public Set<Property> getProperties(Class<? extends Object> type2) throws IntrospectionException {
        return this.getProperties(type2, this.beanAccess);
    }

    public Set<Property> getProperties(Class<? extends Object> type2, BeanAccess bAccess) throws IntrospectionException {
        if (this.readableProperties.containsKey(type2)) {
            return this.readableProperties.get(type2);
        }
        Set<Property> properties = this.createPropertySet(type2, bAccess);
        if (properties.isEmpty()) {
            throw new YAMLException("No JavaBean properties found in " + type2.getName());
        }
        this.readableProperties.put(type2, properties);
        return properties;
    }

    protected Set<Property> createPropertySet(Class<? extends Object> type2, BeanAccess bAccess) throws IntrospectionException {
        TreeSet<Property> properties = new TreeSet<Property>();
        Collection<Property> props = this.getPropertiesMap(type2, bAccess).values();
        for (Property property : props) {
            if (!property.isReadable() || !this.allowReadOnlyProperties && !property.isWritable()) continue;
            properties.add(property);
        }
        return properties;
    }

    public Property getProperty(Class<? extends Object> type2, String name2) throws IntrospectionException {
        return this.getProperty(type2, name2, this.beanAccess);
    }

    public Property getProperty(Class<? extends Object> type2, String name2, BeanAccess bAccess) throws IntrospectionException {
        Map<String, Property> properties = this.getPropertiesMap(type2, bAccess);
        Property property = properties.get(name2);
        if (property == null || !property.isWritable()) {
            throw new YAMLException("Unable to find property '" + name2 + "' on class: " + type2.getName());
        }
        return property;
    }

    public void setBeanAccess(BeanAccess beanAccess) {
        if (this.beanAccess != beanAccess) {
            this.beanAccess = beanAccess;
            this.propertiesCache.clear();
            this.readableProperties.clear();
        }
    }

    public void setAllowReadOnlyProperties(boolean allowReadOnlyProperties) {
        if (this.allowReadOnlyProperties != allowReadOnlyProperties) {
            this.allowReadOnlyProperties = allowReadOnlyProperties;
            this.readableProperties.clear();
        }
    }
}

