/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeLong
extends Number
implements Comparable<NativeLong> {
    public static final int SIZE = Platform.getPlatform().longSize();
    public static final int SHIFT = SIZE == 32 ? 2 : 3;
    public static final long MASK = SIZE == 32 ? 0xFFFFFFFFL : -1L;
    private static final NativeLong ZERO = new NativeLong(0L);
    private static final NativeLong ONE = new NativeLong(1L);
    private static final NativeLong MINUS_ONE = new NativeLong(-1L);
    private final long value;

    public NativeLong(long value2) {
        this.value = value2;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public final boolean equals(Object obj) {
        return obj instanceof NativeLong && this.value == ((NativeLong)obj).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public final int compareTo(NativeLong other) {
        return this.value < other.value ? -1 : (this.value > other.value ? 1 : 0);
    }

    private static final NativeLong _valueOf(long value2) {
        return value2 >= -128L && value2 <= 127L ? Cache.cache[128 + (int)value2] : new NativeLong(value2);
    }

    public static final NativeLong valueOf(long value2) {
        return value2 == 0L ? ZERO : (value2 == 1L ? ONE : (value2 == -1L ? MINUS_ONE : NativeLong._valueOf(value2)));
    }

    public static final NativeLong valueOf(int value2) {
        return NativeLong.valueOf((long)value2);
    }

    private static final class Cache {
        static final NativeLong[] cache = new NativeLong[256];

        private Cache() {
        }

        static {
            for (int i2 = 0; i2 < cache.length; ++i2) {
                Cache.cache[i2] = new NativeLong(i2 - 128);
            }
            Cache.cache[128] = ZERO;
            Cache.cache[129] = ONE;
            Cache.cache[127] = MINUS_ONE;
        }
    }
}

