/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.plaf.ComponentUI;

public class LayerUI<V extends Component>
extends ComponentUI
implements Serializable {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        jComponent.paint(graphics);
    }

    public void eventDispatched(AWTEvent aWTEvent, JLayer<? extends V> jLayer) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent, jLayer);
        } else if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)aWTEvent, jLayer);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent, jLayer);
                    break;
                }
                case 507: {
                    this.processMouseWheelEvent((MouseWheelEvent)aWTEvent, jLayer);
                }
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent, jLayer);
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent, jLayer);
        } else if (aWTEvent instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)aWTEvent, jLayer);
        } else if (aWTEvent instanceof HierarchyEvent) {
            switch (aWTEvent.getID()) {
                case 1400: {
                    this.processHierarchyEvent((HierarchyEvent)aWTEvent, jLayer);
                    break;
                }
                case 1401: 
                case 1402: {
                    this.processHierarchyBoundsEvent((HierarchyEvent)aWTEvent, jLayer);
                }
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent, JLayer<? extends V> jLayer) {
    }

    protected void processFocusEvent(FocusEvent focusEvent, JLayer<? extends V> jLayer) {
    }

    protected void processKeyEvent(KeyEvent keyEvent, JLayer<? extends V> jLayer) {
    }

    protected void processMouseEvent(MouseEvent mouseEvent, JLayer<? extends V> jLayer) {
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent, JLayer<? extends V> jLayer) {
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent, JLayer<? extends V> jLayer) {
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent, JLayer<? extends V> jLayer) {
    }

    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent, JLayer<? extends V> jLayer) {
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent, JLayer<? extends V> jLayer) {
    }

    public void updateUI(JLayer<? extends V> jLayer) {
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.addPropertyChangeListener((JLayer)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.removePropertyChangeListener((JLayer)jComponent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.propertyChangeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void applyPropertyChange(PropertyChangeEvent propertyChangeEvent, JLayer<? extends V> jLayer) {
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        JLayer jLayer = (JLayer)jComponent;
        if (jLayer.getView() != null) {
            return ((Component)jLayer.getView()).getBaseline(n, n2);
        }
        return super.getBaseline(jComponent, n, n2);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        JLayer jLayer = (JLayer)jComponent;
        if (jLayer.getView() != null) {
            return ((Component)jLayer.getView()).getBaselineResizeBehavior();
        }
        return super.getBaselineResizeBehavior(jComponent);
    }

    public void doLayout(JLayer<? extends V> jLayer) {
        JPanel jPanel;
        V v = jLayer.getView();
        if (v != null) {
            ((Component)v).setBounds(0, 0, jLayer.getWidth(), jLayer.getHeight());
        }
        if ((jPanel = jLayer.getGlassPane()) != null) {
            jPanel.setBounds(0, 0, jLayer.getWidth(), jLayer.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        JLayer jLayer = (JLayer)jComponent;
        Object v = jLayer.getView();
        if (v != null) {
            return ((Component)v).getPreferredSize();
        }
        return super.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        JLayer jLayer = (JLayer)jComponent;
        Object v = jLayer.getView();
        if (v != null) {
            return ((Component)v).getMinimumSize();
        }
        return super.getMinimumSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        JLayer jLayer = (JLayer)jComponent;
        Object v = jLayer.getView();
        if (v != null) {
            return ((Component)v).getMaximumSize();
        }
        return super.getMaximumSize(jComponent);
    }

    public void repaint(long l, int n, int n2, int n3, int n4, JLayer<? extends V> jLayer) {
        RepaintManager.currentManager(jLayer).addDirtyRegion(jLayer, n, n2, n3, n4);
    }
}

