/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.example.debug.bdi.AmbiguousMethodException;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpecList;
import com.sun.tools.example.debug.bdi.MalformedMemberNameException;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MethodBreakpointSpec
extends BreakpointSpec {
    String methodId;
    List<String> methodArgs;

    MethodBreakpointSpec(EventRequestSpecList eventRequestSpecList, ReferenceTypeSpec referenceTypeSpec, String string, List<String> list) {
        super(eventRequestSpecList, referenceTypeSpec);
        this.methodId = string;
        this.methodArgs = list;
    }

    @Override
    void resolve(ReferenceType referenceType) throws MalformedMemberNameException, AmbiguousMethodException, InvalidTypeException, NoSuchMethodException, NoSessionException {
        if (!this.isValidMethodName(this.methodId)) {
            throw new MalformedMemberNameException(this.methodId);
        }
        if (!(referenceType instanceof ClassType)) {
            throw new InvalidTypeException();
        }
        Location location = this.location((ClassType)referenceType);
        this.setRequest(referenceType.virtualMachine().eventRequestManager().createBreakpointRequest(location));
    }

    private Location location(ClassType classType) throws AmbiguousMethodException, NoSuchMethodException, NoSessionException {
        Method method = this.findMatchingMethod(classType);
        Location location = method.location();
        return location;
    }

    public String methodName() {
        return this.methodId;
    }

    public List<String> methodArgs() {
        return this.methodArgs;
    }

    public int hashCode() {
        return this.refSpec.hashCode() + (this.methodId != null ? this.methodId.hashCode() : 0) + (this.methodArgs != null ? this.methodArgs.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object instanceof MethodBreakpointSpec) {
            MethodBreakpointSpec methodBreakpointSpec = (MethodBreakpointSpec)object;
            return this.methodId.equals(methodBreakpointSpec.methodId) && this.methodArgs.equals(methodBreakpointSpec.methodArgs) && this.refSpec.equals(methodBreakpointSpec.refSpec);
        }
        return false;
    }

    @Override
    public String errorMessageFor(Exception exception) {
        if (exception instanceof AmbiguousMethodException) {
            return "Method " + this.methodName() + " is overloaded; specify arguments";
        }
        if (exception instanceof NoSuchMethodException) {
            return "No method " + this.methodName() + " in " + this.refSpec;
        }
        if (exception instanceof InvalidTypeException) {
            return "Breakpoints can be located only in classes. " + this.refSpec + " is an interface or array";
        }
        return super.errorMessageFor(exception);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("breakpoint ");
        stringBuffer.append(this.refSpec.toString());
        stringBuffer.append('.');
        stringBuffer.append(this.methodId);
        if (this.methodArgs != null) {
            boolean bl = true;
            stringBuffer.append('(');
            for (String string : this.methodArgs) {
                if (!bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(string);
                bl = false;
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(" (");
        stringBuffer.append(this.getStatusString());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private boolean isValidMethodName(String string) {
        return this.isJavaIdentifier(string) || string.equals("<init>") || string.equals("<clinit>");
    }

    private boolean compareArgTypes(Method method, List<String> list) {
        List<String> list2 = method.argumentTypeNames();
        if (list2.size() != list.size()) {
            return false;
        }
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = list2.get(i);
            if (string2.equals(string = list.get(i))) continue;
            if (i != n - 1 || !method.isVarArgs() || !string.endsWith("...")) {
                return false;
            }
            int n2 = string2.length();
            if (n2 + 1 != string.length()) {
                return false;
            }
            return string2.regionMatches(0, string, 0, n2 - 2);
        }
        return true;
    }

    private VirtualMachine vm() {
        return this.request.virtualMachine();
    }

    private String normalizeArgTypeName(String string) throws NoSessionException {
        char c;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        string = string.trim();
        int n2 = string.length();
        boolean bl = string.endsWith("...");
        if (bl) {
            n2 -= 3;
        }
        while (n < n2 && !Character.isWhitespace(c = string.charAt(n)) && c != '[') {
            stringBuffer.append(c);
            ++n;
        }
        while (n < n2) {
            c = string.charAt(n);
            if (c == '[' || c == ']') {
                stringBuffer2.append(c);
            } else if (!Character.isWhitespace(c)) {
                throw new IllegalArgumentException("Invalid argument type name");
            }
            ++n;
        }
        string = stringBuffer.toString();
        if (string.indexOf(46) == -1 || string.startsWith("*.")) {
            try {
                List<ReferenceType> list = this.specs.runtime.findClassesMatchingPattern(string);
                if (list.size() > 0) {
                    string = list.get(0).name();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        string = string + stringBuffer2.toString();
        if (bl) {
            string = string + "...";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method findMatchingMethod(ClassType classType) throws AmbiguousMethodException, NoSuchMethodException, NoSessionException {
        void var4_8;
        ArrayList<String> arrayList = null;
        if (this.methodArgs() != null) {
            arrayList = new ArrayList<String>(this.methodArgs().size());
            for (String string : this.methodArgs()) {
                String string2 = this.normalizeArgTypeName(string);
                arrayList.add(string2);
            }
        }
        Object object = null;
        Object var4_6 = null;
        int n = 0;
        for (Method method : classType.methods()) {
            if (!method.name().equals(this.methodName())) continue;
            if (++n == 1) {
                object = method;
            }
            if (arrayList == null || !this.compareArgTypes(method, arrayList)) continue;
            Method method2 = method;
            break;
        }
        Iterator<Object> iterator = null;
        if (var4_8 != null) {
            return var4_8;
        }
        if (arrayList != null) throw new NoSuchMethodException(this.methodName());
        if (n <= 0) throw new NoSuchMethodException(this.methodName());
        if (n != 1) throw new AmbiguousMethodException();
        return object;
    }
}

