/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.Attributes;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import sun.nio.fs.DynamicFileAttributeView;

abstract class AbstractPath
extends Path {
    private static final DirectoryStream.Filter<Path> acceptAllFilter = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path path) {
            return true;
        }
    };
    private static final WatchEvent.Modifier[] NO_MODIFIERS = new WatchEvent.Modifier[0];

    protected AbstractPath() {
    }

    @Override
    public final Path createFile(FileAttribute<?> ... fileAttributeArray) throws IOException {
        EnumSet<StandardOpenOption> enumSet = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        SeekableByteChannel seekableByteChannel = this.newByteChannel(enumSet, fileAttributeArray);
        try {
            seekableByteChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    abstract void implDelete(boolean var1) throws IOException;

    @Override
    public final void delete() throws IOException {
        this.implDelete(true);
    }

    @Override
    public final void deleteIfExists() throws IOException {
        this.implDelete(false);
    }

    @Override
    public final InputStream newInputStream(OpenOption ... openOptionArray) throws IOException {
        if (openOptionArray.length > 0) {
            for (OpenOption openOption : openOptionArray) {
                if (openOption == StandardOpenOption.READ) continue;
                throw new UnsupportedOperationException("'" + openOption + "' not allowed");
            }
        }
        return Channels.newInputStream(this.newByteChannel(new OpenOption[0]));
    }

    @Override
    public final OutputStream newOutputStream(OpenOption ... openOptionArray) throws IOException {
        int n = openOptionArray.length;
        HashSet<OpenOption> hashSet = new HashSet<OpenOption>(n + 3);
        if (n == 0) {
            hashSet.add(StandardOpenOption.CREATE);
            hashSet.add(StandardOpenOption.TRUNCATE_EXISTING);
        } else {
            for (OpenOption openOption : openOptionArray) {
                if (openOption == StandardOpenOption.READ) {
                    throw new IllegalArgumentException("READ not allowed");
                }
                hashSet.add(openOption);
            }
        }
        hashSet.add(StandardOpenOption.WRITE);
        return Channels.newOutputStream(this.newByteChannel(hashSet, new FileAttribute[0]));
    }

    @Override
    public final SeekableByteChannel newByteChannel(OpenOption ... openOptionArray) throws IOException {
        HashSet hashSet = new HashSet(openOptionArray.length);
        Collections.addAll(hashSet, openOptionArray);
        return this.newByteChannel(hashSet, new FileAttribute[0]);
    }

    @Override
    public final DirectoryStream<Path> newDirectoryStream() throws IOException {
        return this.newDirectoryStream(acceptAllFilter);
    }

    @Override
    public final DirectoryStream<Path> newDirectoryStream(String string) throws IOException {
        if (string.equals("*")) {
            return this.newDirectoryStream();
        }
        final PathMatcher pathMatcher = this.getFileSystem().getPathMatcher("glob:" + string);
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return pathMatcher.matches(path.getName());
            }
        };
        return this.newDirectoryStream((DirectoryStream.Filter<? super Path>)filter);
    }

    @Override
    public final boolean exists() {
        try {
            this.checkAccess(new AccessMode[0]);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public final boolean notExists() {
        try {
            this.checkAccess(new AccessMode[0]);
            return false;
        }
        catch (NoSuchFileException noSuchFileException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public final WatchKey register(WatchService watchService, WatchEvent.Kind<?> ... kindArray) throws IOException {
        return this.register(watchService, kindArray, NO_MODIFIERS);
    }

    abstract void implCopyTo(Path var1, CopyOption ... var2) throws IOException;

    @Override
    public final Path copyTo(Path path, CopyOption ... copyOptionArray) throws IOException {
        if (this.getFileSystem().provider() == path.getFileSystem().provider()) {
            this.implCopyTo(path, copyOptionArray);
        } else {
            this.copyToForeignTarget(path, copyOptionArray);
        }
        return path;
    }

    abstract void implMoveTo(Path var1, CopyOption ... var2) throws IOException;

    @Override
    public final Path moveTo(Path path, CopyOption ... copyOptionArray) throws IOException {
        if (this.getFileSystem().provider() == path.getFileSystem().provider()) {
            this.implMoveTo(path, copyOptionArray);
        } else {
            this.copyToForeignTarget(path, AbstractPath.convertMoveToCopyOptions(copyOptionArray));
            this.delete();
        }
        return path;
    }

    private static CopyOption[] convertMoveToCopyOptions(CopyOption ... copyOptionArray) throws AtomicMoveNotSupportedException {
        int n = copyOptionArray.length;
        CopyOption[] copyOptionArray2 = new CopyOption[n + 2];
        for (int i = 0; i < n; ++i) {
            CopyOption copyOption = copyOptionArray[i];
            if (copyOption == StandardCopyOption.ATOMIC_MOVE) {
                throw new AtomicMoveNotSupportedException(null, null, "Atomic move between providers is not supported");
            }
            copyOptionArray2[i] = copyOption;
        }
        copyOptionArray2[n] = LinkOption.NOFOLLOW_LINKS;
        copyOptionArray2[n + 1] = StandardCopyOption.COPY_ATTRIBUTES;
        return copyOptionArray2;
    }

    private void copyToForeignTarget(Path path, CopyOption ... copyOptionArray) throws IOException {
        boolean bl;
        LinkOption[] linkOptionArray;
        CopyOptions copyOptions = CopyOptions.parse(copyOptionArray);
        if (copyOptions.followLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptionArray3 = linkOptionArray;
        BasicFileAttributes basicFileAttributes = Attributes.readBasicFileAttributes(this, linkOptionArray3);
        if (basicFileAttributes.isSymbolicLink()) {
            throw new IOException("Copying of symbolic links not supported");
        }
        if (copyOptions.replaceExisting) {
            try {
                path.deleteIfExists();
                bl = false;
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                bl = true;
            }
        } else {
            bl = path.exists();
        }
        if (bl) {
            throw new FileAlreadyExistsException(path.toString());
        }
        if (basicFileAttributes.isDirectory()) {
            path.createDirectory(new FileAttribute[0]);
        } else {
            this.copyRegularFileToForeignTarget(path);
        }
        if (copyOptions.copyAttributes) {
            BasicFileAttributeView basicFileAttributeView = path.getFileAttributeView(BasicFileAttributeView.class, linkOptionArray3);
            try {
                basicFileAttributeView.setTimes(basicFileAttributes.lastModifiedTime(), basicFileAttributes.lastAccessTime(), basicFileAttributes.creationTime());
            }
            catch (IOException iOException) {
                try {
                    path.delete();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRegularFileToForeignTarget(Path path) throws IOException {
        try (SeekableByteChannel seekableByteChannel = this.newByteChannel(new OpenOption[0]);
             SeekableByteChannel seekableByteChannel2 = path.newByteChannel(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[8192]);
            int n = 0;
            while ((n = seekableByteChannel.read(byteBuffer)) >= 0) {
                assert (n > 0);
                byteBuffer.flip();
                while (byteBuffer.hasRemaining()) {
                    seekableByteChannel2.write(byteBuffer);
                }
                byteBuffer.rewind();
            }
        }
    }

    private static String[] split(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(58);
        if (n == -1) {
            stringArray[0] = "basic";
            stringArray[1] = string;
        } else {
            stringArray[0] = string.substring(0, n++);
            stringArray[1] = n == string.length() ? "" : string.substring(n);
        }
        return stringArray;
    }

    abstract DynamicFileAttributeView getFileAttributeView(String var1, LinkOption ... var2);

    @Override
    public final void setAttribute(String string, Object object, LinkOption ... linkOptionArray) throws IOException {
        String[] stringArray = AbstractPath.split(string);
        DynamicFileAttributeView dynamicFileAttributeView = this.getFileAttributeView(stringArray[0], linkOptionArray);
        if (dynamicFileAttributeView == null) {
            throw new UnsupportedOperationException("View '" + stringArray[0] + "' not available");
        }
        dynamicFileAttributeView.setAttribute(stringArray[1], object);
    }

    @Override
    public final Object getAttribute(String string, LinkOption ... linkOptionArray) throws IOException {
        String[] stringArray = AbstractPath.split(string);
        DynamicFileAttributeView dynamicFileAttributeView = this.getFileAttributeView(stringArray[0], linkOptionArray);
        return dynamicFileAttributeView == null ? null : dynamicFileAttributeView.getAttribute(stringArray[1]);
    }

    @Override
    public final Map<String, ?> readAttributes(String string, LinkOption ... linkOptionArray) throws IOException {
        String[] stringArray = AbstractPath.split(string);
        DynamicFileAttributeView dynamicFileAttributeView = this.getFileAttributeView(stringArray[0], linkOptionArray);
        if (dynamicFileAttributeView == null) {
            return Collections.emptyMap();
        }
        return dynamicFileAttributeView.readAttributes(stringArray[1].split(","));
    }

    private static class CopyOptions {
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean followLinks = true;

        private CopyOptions() {
        }

        static CopyOptions parse(CopyOption ... copyOptionArray) {
            CopyOptions copyOptions = new CopyOptions();
            for (CopyOption copyOption : copyOptionArray) {
                if (copyOption == StandardCopyOption.REPLACE_EXISTING) {
                    copyOptions.replaceExisting = true;
                    continue;
                }
                if (copyOption == LinkOption.NOFOLLOW_LINKS) {
                    copyOptions.followLinks = false;
                    continue;
                }
                if (copyOption == StandardCopyOption.COPY_ATTRIBUTES) {
                    copyOptions.copyAttributes = true;
                    continue;
                }
                if (copyOption == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException("'" + copyOption + "' is not a recognized copy option");
            }
            return copyOptions;
        }
    }
}

