/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AWTPermission;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.Permission;
import sun.awt.image.SurfaceManager;
import sun.java2d.DisposerTarget;
import sun.java2d.NullSurfaceData;
import sun.java2d.StateTrackable;
import sun.java2d.StateTrackableDelegate;
import sun.java2d.StateTracker;
import sun.java2d.SunGraphics2D;
import sun.java2d.Surface;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.DrawGlyphList;
import sun.java2d.loops.DrawGlyphListAA;
import sun.java2d.loops.DrawGlyphListLCD;
import sun.java2d.loops.DrawLine;
import sun.java2d.loops.DrawPath;
import sun.java2d.loops.DrawPolygons;
import sun.java2d.loops.DrawRect;
import sun.java2d.loops.FillPath;
import sun.java2d.loops.FillRect;
import sun.java2d.loops.FillSpans;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.RenderCache;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.AAShapePipe;
import sun.java2d.pipe.AATextRenderer;
import sun.java2d.pipe.AlphaColorPipe;
import sun.java2d.pipe.AlphaPaintPipe;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.DrawImage;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.GeneralCompositePipe;
import sun.java2d.pipe.LCDTextRenderer;
import sun.java2d.pipe.LoopBasedPipe;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.OutlineTextRenderer;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.SolidTextRenderer;
import sun.java2d.pipe.SpanClipRenderer;
import sun.java2d.pipe.SpanShapeRenderer;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.TextRenderer;

public abstract class SurfaceData
implements Transparency,
DisposerTarget,
StateTrackable,
Surface {
    private long pData;
    private boolean valid;
    private boolean surfaceLost;
    private SurfaceType surfaceType;
    private ColorModel colorModel;
    private Object disposerReferent = new Object();
    private Object blitProxyKey;
    private StateTrackableDelegate stateDelegate;
    protected static final LoopPipe colorPrimitives;
    public static final TextPipe outlineTextRenderer;
    public static final TextPipe solidTextRenderer;
    public static final TextPipe aaTextRenderer;
    public static final TextPipe lcdTextRenderer;
    protected static final CompositePipe colorPipe;
    protected static final PixelToShapeConverter colorViaShape;
    protected static final TextPipe colorText;
    protected static final CompositePipe clipColorPipe;
    protected static final TextPipe clipColorText;
    protected static final AAShapePipe AAColorShape;
    protected static final PixelToShapeConverter AAColorViaShape;
    protected static final AAShapePipe AAClipColorShape;
    protected static final PixelToShapeConverter AAClipColorViaShape;
    protected static final CompositePipe paintPipe;
    protected static final SpanShapeRenderer paintShape;
    protected static final PixelToShapeConverter paintViaShape;
    protected static final TextPipe paintText;
    protected static final CompositePipe clipPaintPipe;
    protected static final TextPipe clipPaintText;
    protected static final AAShapePipe AAPaintShape;
    protected static final PixelToShapeConverter AAPaintViaShape;
    protected static final AAShapePipe AAClipPaintShape;
    protected static final PixelToShapeConverter AAClipPaintViaShape;
    protected static final CompositePipe compPipe;
    protected static final SpanShapeRenderer compShape;
    protected static final PixelToShapeConverter compViaShape;
    protected static final TextPipe compText;
    protected static final CompositePipe clipCompPipe;
    protected static final TextPipe clipCompText;
    protected static final AAShapePipe AACompShape;
    protected static final PixelToShapeConverter AACompViaShape;
    protected static final AAShapePipe AAClipCompShape;
    protected static final PixelToShapeConverter AAClipCompViaShape;
    protected static final DrawImagePipe imagepipe;
    static final int LCDLOOP_UNKNOWN = 0;
    static final int LCDLOOP_FOUND = 1;
    static final int LCDLOOP_NOTFOUND = 2;
    int haveLCDLoop;
    private static RenderCache loopcache;
    static Permission compPermission;

    private static native void initIDs();

    protected SurfaceData(SurfaceType surfaceType, ColorModel colorModel) {
        this(StateTrackable.State.STABLE, surfaceType, colorModel);
    }

    protected SurfaceData(StateTrackable.State state, SurfaceType surfaceType, ColorModel colorModel) {
        this(StateTrackableDelegate.createInstance(state), surfaceType, colorModel);
    }

    protected SurfaceData(StateTrackableDelegate stateTrackableDelegate, SurfaceType surfaceType, ColorModel colorModel) {
        this.stateDelegate = stateTrackableDelegate;
        this.colorModel = colorModel;
        this.surfaceType = surfaceType;
        this.valid = true;
    }

    protected SurfaceData(StateTrackable.State state) {
        this.stateDelegate = StateTrackableDelegate.createInstance(state);
        this.valid = true;
    }

    protected void setBlitProxyKey(Object object) {
        if (SurfaceDataProxy.isCachingAllowed()) {
            this.blitProxyKey = object;
        }
    }

    public SurfaceData getSourceSurfaceData(Image image, int n, CompositeType compositeType, Color color) {
        SurfaceManager surfaceManager = SurfaceManager.getManager(image);
        SurfaceData surfaceData = surfaceManager.getPrimarySurfaceData();
        if (image.getAccelerationPriority() > 0.0f && this.blitProxyKey != null) {
            SurfaceDataProxy surfaceDataProxy = (SurfaceDataProxy)surfaceManager.getCacheData(this.blitProxyKey);
            if (surfaceDataProxy == null || !surfaceDataProxy.isValid()) {
                surfaceDataProxy = surfaceData.getState() == StateTrackable.State.UNTRACKABLE ? SurfaceDataProxy.UNCACHED : this.makeProxyFor(surfaceData);
                surfaceManager.setCacheData(this.blitProxyKey, surfaceDataProxy);
            }
            surfaceData = surfaceDataProxy.replaceData(surfaceData, n, compositeType, color);
        }
        return surfaceData;
    }

    public SurfaceDataProxy makeProxyFor(SurfaceData surfaceData) {
        return SurfaceDataProxy.UNCACHED;
    }

    public static SurfaceData getPrimarySurfaceData(Image image) {
        SurfaceManager surfaceManager = SurfaceManager.getManager(image);
        return surfaceManager.getPrimarySurfaceData();
    }

    public static SurfaceData restoreContents(Image image) {
        SurfaceManager surfaceManager = SurfaceManager.getManager(image);
        return surfaceManager.restoreContents();
    }

    @Override
    public StateTrackable.State getState() {
        return this.stateDelegate.getState();
    }

    @Override
    public StateTracker getStateTracker() {
        return this.stateDelegate.getStateTracker();
    }

    public final void markDirty() {
        this.stateDelegate.markDirty();
    }

    public void setSurfaceLost(boolean bl) {
        this.surfaceLost = bl;
        this.stateDelegate.markDirty();
    }

    public boolean isSurfaceLost() {
        return this.surfaceLost;
    }

    public final boolean isValid() {
        return this.valid;
    }

    @Override
    public Object getDisposerReferent() {
        return this.disposerReferent;
    }

    public long getNativeOps() {
        return this.pData;
    }

    public void invalidate() {
        this.valid = false;
        this.stateDelegate.markDirty();
    }

    public abstract SurfaceData getReplacement();

    public boolean canRenderLCDText(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.compositeState <= 0 && sunGraphics2D.paintState <= 1 && sunGraphics2D.clipState <= 1 && sunGraphics2D.surfaceData.getTransparency() == 1) {
            if (this.haveLCDLoop == 0) {
                DrawGlyphListLCD drawGlyphListLCD = DrawGlyphListLCD.locate(SurfaceType.AnyColor, CompositeType.SrcNoEa, this.getSurfaceType());
                this.haveLCDLoop = drawGlyphListLCD != null ? 1 : 2;
            }
            return this.haveLCDLoop == 1;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void validatePipe(SunGraphics2D var1_1) {
        block20: {
            block22: {
                block23: {
                    block24: {
                        block21: {
                            block19: {
                                var1_1.imagepipe = SurfaceData.imagepipe;
                                if (var1_1.compositeState != 2) break block19;
                                if (var1_1.paintState > 1) {
                                    var1_1.drawpipe = SurfaceData.paintViaShape;
                                    var1_1.fillpipe = SurfaceData.paintViaShape;
                                    var1_1.shapepipe = SurfaceData.paintShape;
                                    var1_1.textpipe = SurfaceData.outlineTextRenderer;
                                } else {
                                    if (var1_1.clipState == 2) {
                                        var1_1.drawpipe = SurfaceData.colorViaShape;
                                        var1_1.fillpipe = SurfaceData.colorViaShape;
                                        var1_1.textpipe = SurfaceData.outlineTextRenderer;
                                    } else {
                                        if (var1_1.transformState >= 3) {
                                            var1_1.drawpipe = SurfaceData.colorViaShape;
                                            var1_1.fillpipe = SurfaceData.colorViaShape;
                                        } else {
                                            var1_1.drawpipe = var1_1.strokeState != 0 ? SurfaceData.colorViaShape : SurfaceData.colorPrimitives;
                                            var1_1.fillpipe = SurfaceData.colorPrimitives;
                                        }
                                        var1_1.textpipe = SurfaceData.solidTextRenderer;
                                    }
                                    var1_1.shapepipe = SurfaceData.colorPrimitives;
                                }
                                break block20;
                            }
                            if (var1_1.compositeState != 3) break block21;
                            if (var1_1.antialiasHint == 2) {
                                if (var1_1.clipState == 2) {
                                    var1_1.drawpipe = SurfaceData.AAClipCompViaShape;
                                    var1_1.fillpipe = SurfaceData.AAClipCompViaShape;
                                    var1_1.shapepipe = SurfaceData.AAClipCompShape;
                                    var1_1.textpipe = SurfaceData.clipCompText;
                                } else {
                                    var1_1.drawpipe = SurfaceData.AACompViaShape;
                                    var1_1.fillpipe = SurfaceData.AACompViaShape;
                                    var1_1.shapepipe = SurfaceData.AACompShape;
                                    var1_1.textpipe = SurfaceData.compText;
                                }
                            } else {
                                var1_1.drawpipe = SurfaceData.compViaShape;
                                var1_1.fillpipe = SurfaceData.compViaShape;
                                var1_1.shapepipe = SurfaceData.compShape;
                                var1_1.textpipe = var1_1.clipState == 2 ? SurfaceData.clipCompText : SurfaceData.compText;
                            }
                            break block20;
                        }
                        if (var1_1.antialiasHint != 2) break block22;
                        var1_1.alphafill = this.getMaskFill(var1_1);
                        if (var1_1.alphafill == null) break block23;
                        if (var1_1.clipState != 2) break block24;
                        var1_1.drawpipe = SurfaceData.AAClipColorViaShape;
                        var1_1.fillpipe = SurfaceData.AAClipColorViaShape;
                        var1_1.shapepipe = SurfaceData.AAClipColorShape;
                        var1_1.textpipe = SurfaceData.clipColorText;
                        break block20;
                    }
                    var1_1.drawpipe = SurfaceData.AAColorViaShape;
                    var1_1.fillpipe = SurfaceData.AAColorViaShape;
                    var1_1.shapepipe = SurfaceData.AAColorShape;
                    if (var1_1.paintState > 0) ** GOTO lbl-1000
                    if (var1_1.compositeState > 0) lbl-1000:
                    // 2 sources

                    {
                        var1_1.textpipe = SurfaceData.colorText;
                    } else {
                        var1_1.textpipe = this.getTextPipe(var1_1, true);
                    }
                    break block20;
                }
                if (var1_1.clipState == 2) {
                    var1_1.drawpipe = SurfaceData.AAClipPaintViaShape;
                    var1_1.fillpipe = SurfaceData.AAClipPaintViaShape;
                    var1_1.shapepipe = SurfaceData.AAClipPaintShape;
                    var1_1.textpipe = SurfaceData.clipPaintText;
                } else {
                    var1_1.drawpipe = SurfaceData.AAPaintViaShape;
                    var1_1.fillpipe = SurfaceData.AAPaintViaShape;
                    var1_1.shapepipe = SurfaceData.AAPaintShape;
                    var1_1.textpipe = SurfaceData.paintText;
                }
                break block20;
            }
            if (var1_1.paintState > 1) ** GOTO lbl-1000
            if (var1_1.compositeState > 0) ** GOTO lbl-1000
            if (var1_1.clipState == 2) lbl-1000:
            // 3 sources

            {
                var1_1.drawpipe = SurfaceData.paintViaShape;
                var1_1.fillpipe = SurfaceData.paintViaShape;
                var1_1.shapepipe = SurfaceData.paintShape;
                var1_1.alphafill = this.getMaskFill(var1_1);
                var1_1.textpipe = var1_1.alphafill != null ? (var1_1.clipState == 2 ? SurfaceData.clipColorText : SurfaceData.colorText) : (var1_1.clipState == 2 ? SurfaceData.clipPaintText : SurfaceData.paintText);
            } else {
                if (var1_1.transformState >= 3) {
                    var1_1.drawpipe = SurfaceData.colorViaShape;
                    var1_1.fillpipe = SurfaceData.colorViaShape;
                } else {
                    var1_1.drawpipe = var1_1.strokeState != 0 ? SurfaceData.colorViaShape : SurfaceData.colorPrimitives;
                    var1_1.fillpipe = SurfaceData.colorPrimitives;
                }
                var1_1.textpipe = this.getTextPipe(var1_1, false);
                var1_1.shapepipe = SurfaceData.colorPrimitives;
            }
        }
        if (var1_1.textpipe instanceof LoopBasedPipe || var1_1.shapepipe instanceof LoopBasedPipe || var1_1.fillpipe instanceof LoopBasedPipe || var1_1.drawpipe instanceof LoopBasedPipe || var1_1.imagepipe instanceof LoopBasedPipe) {
            var1_1.loops = this.getRenderLoops(var1_1);
        }
    }

    private TextPipe getTextPipe(SunGraphics2D sunGraphics2D, boolean bl) {
        switch (sunGraphics2D.textAntialiasHint) {
            case 0: {
                if (bl) {
                    return aaTextRenderer;
                }
                return solidTextRenderer;
            }
            case 1: {
                return solidTextRenderer;
            }
            case 2: {
                return aaTextRenderer;
            }
        }
        switch (sunGraphics2D.getFontInfo().aaHint) {
            case 4: 
            case 6: {
                return lcdTextRenderer;
            }
            case 2: {
                return aaTextRenderer;
            }
            case 1: {
                return solidTextRenderer;
            }
        }
        if (bl) {
            return aaTextRenderer;
        }
        return solidTextRenderer;
    }

    private static SurfaceType getPaintSurfaceType(SunGraphics2D sunGraphics2D) {
        switch (sunGraphics2D.paintState) {
            case 0: {
                return SurfaceType.OpaqueColor;
            }
            case 1: {
                return SurfaceType.AnyColor;
            }
            case 2: {
                if (sunGraphics2D.paint.getTransparency() == 1) {
                    return SurfaceType.OpaqueGradientPaint;
                }
                return SurfaceType.GradientPaint;
            }
            case 3: {
                if (sunGraphics2D.paint.getTransparency() == 1) {
                    return SurfaceType.OpaqueLinearGradientPaint;
                }
                return SurfaceType.LinearGradientPaint;
            }
            case 4: {
                if (sunGraphics2D.paint.getTransparency() == 1) {
                    return SurfaceType.OpaqueRadialGradientPaint;
                }
                return SurfaceType.RadialGradientPaint;
            }
            case 5: {
                if (sunGraphics2D.paint.getTransparency() == 1) {
                    return SurfaceType.OpaqueTexturePaint;
                }
                return SurfaceType.TexturePaint;
            }
        }
        return SurfaceType.AnyPaint;
    }

    protected MaskFill getMaskFill(SunGraphics2D sunGraphics2D) {
        return MaskFill.getFromCache(SurfaceData.getPaintSurfaceType(sunGraphics2D), sunGraphics2D.imageComp, this.getSurfaceType());
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        SurfaceType surfaceType;
        SurfaceType surfaceType2 = SurfaceData.getPaintSurfaceType(sunGraphics2D);
        CompositeType compositeType = sunGraphics2D.compositeState == 0 ? CompositeType.SrcNoEa : sunGraphics2D.imageComp;
        Object object = loopcache.get(surfaceType2, compositeType, surfaceType = sunGraphics2D.getSurfaceData().getSurfaceType());
        if (object != null) {
            return (RenderLoops)object;
        }
        RenderLoops renderLoops = SurfaceData.makeRenderLoops(surfaceType2, compositeType, surfaceType);
        loopcache.put(surfaceType2, compositeType, surfaceType, renderLoops);
        return renderLoops;
    }

    public static RenderLoops makeRenderLoops(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        RenderLoops renderLoops = new RenderLoops();
        renderLoops.drawLineLoop = DrawLine.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.fillRectLoop = FillRect.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawRectLoop = DrawRect.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawPolygonsLoop = DrawPolygons.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawPathLoop = DrawPath.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.fillPathLoop = FillPath.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.fillSpansLoop = FillSpans.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawGlyphListLoop = DrawGlyphList.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawGlyphListAALoop = DrawGlyphListAA.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawGlyphListLCDLoop = DrawGlyphListLCD.locate(surfaceType, compositeType, surfaceType2);
        return renderLoops;
    }

    public abstract GraphicsConfiguration getDeviceConfiguration();

    public final SurfaceType getSurfaceType() {
        return this.surfaceType;
    }

    public final ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public int getTransparency() {
        return this.getColorModel().getTransparency();
    }

    public abstract Raster getRaster(int var1, int var2, int var3, int var4);

    public boolean useTightBBoxes() {
        return true;
    }

    public int pixelFor(int n) {
        return this.surfaceType.pixelFor(n, this.colorModel);
    }

    public int pixelFor(Color color) {
        return this.pixelFor(color.getRGB());
    }

    public int rgbFor(int n) {
        return this.surfaceType.rgbFor(n, this.colorModel);
    }

    public abstract Rectangle getBounds();

    protected void checkCustomComposite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (compPermission == null) {
                compPermission = new AWTPermission("readDisplayPixels");
            }
            securityManager.checkPermission(compPermission);
        }
    }

    protected static native boolean isOpaqueGray(IndexColorModel var0);

    public static boolean isNull(SurfaceData surfaceData) {
        return surfaceData == null || surfaceData == NullSurfaceData.theInstance;
    }

    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        return false;
    }

    public void flush() {
    }

    public abstract Object getDestination();

    static {
        SurfaceData.initIDs();
        colorPrimitives = new LoopPipe();
        outlineTextRenderer = new OutlineTextRenderer();
        solidTextRenderer = new SolidTextRenderer();
        aaTextRenderer = new AATextRenderer();
        lcdTextRenderer = new LCDTextRenderer();
        colorPipe = new AlphaColorPipe();
        colorViaShape = new PixelToShapeConverter(colorPrimitives);
        colorText = new TextRenderer(colorPipe);
        clipColorPipe = new SpanClipRenderer(colorPipe);
        clipColorText = new TextRenderer(clipColorPipe);
        AAColorShape = new AAShapePipe(colorPipe);
        AAColorViaShape = new PixelToShapeConverter(AAColorShape);
        AAClipColorShape = new AAShapePipe(clipColorPipe);
        AAClipColorViaShape = new PixelToShapeConverter(AAClipColorShape);
        paintPipe = new AlphaPaintPipe();
        paintShape = new SpanShapeRenderer.Composite(paintPipe);
        paintViaShape = new PixelToShapeConverter(paintShape);
        paintText = new TextRenderer(paintPipe);
        clipPaintPipe = new SpanClipRenderer(paintPipe);
        clipPaintText = new TextRenderer(clipPaintPipe);
        AAPaintShape = new AAShapePipe(paintPipe);
        AAPaintViaShape = new PixelToShapeConverter(AAPaintShape);
        AAClipPaintShape = new AAShapePipe(clipPaintPipe);
        AAClipPaintViaShape = new PixelToShapeConverter(AAClipPaintShape);
        compPipe = new GeneralCompositePipe();
        compShape = new SpanShapeRenderer.Composite(compPipe);
        compViaShape = new PixelToShapeConverter(compShape);
        compText = new TextRenderer(compPipe);
        clipCompPipe = new SpanClipRenderer(compPipe);
        clipCompText = new TextRenderer(clipCompPipe);
        AACompShape = new AAShapePipe(compPipe);
        AACompViaShape = new PixelToShapeConverter(AACompShape);
        AAClipCompShape = new AAShapePipe(clipCompPipe);
        AAClipCompViaShape = new PixelToShapeConverter(AAClipCompShape);
        imagepipe = new DrawImage();
        loopcache = new RenderCache(30);
    }
}

