/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import sun.misc.Unsafe;

public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    private static final int NORMAL = -1;
    private static final int CANCELLED = -2;
    private static final int EXCEPTIONAL = -3;
    private static final int SIGNAL = 1;
    static final Map<ForkJoinTask<?>, Throwable> exceptionMap = Collections.synchronizedMap(new WeakHashMap());
    private static final long serialVersionUID = -7721805057305804111L;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long statusOffset = ForkJoinTask.objectFieldOffset("status", ForkJoinTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompletion(int n) {
        int n2;
        while ((n2 = this.status) >= 0) {
            if (!UNSAFE.compareAndSwapInt(this, statusOffset, n2, n)) continue;
            if (n2 == 0) break;
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                this.notifyAll();
                break;
            }
        }
    }

    private void setExceptionalCompletion(Throwable throwable) {
        exceptionMap.put(this, throwable);
        this.setCompletion(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalAwaitDone() {
        int n;
        while ((n = this.status) >= 0) {
            try {
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    if (UNSAFE.compareAndSwapInt(this, statusOffset, n, 1)) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.cancelIfTerminating();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int internalAwaitDone(long l) {
        int n = this.status;
        if (n >= 0) {
            try {
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    if (UNSAFE.compareAndSwapInt(this, statusOffset, n, 1)) {
                        this.wait(l, 0);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.cancelIfTerminating();
            }
            n = this.status;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externalAwaitDone() {
        int n;
        while ((n = this.status) >= 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                if (UNSAFE.compareAndSwapInt(this, statusOffset, n, 1)) {
                    boolean bl = false;
                    while (this.status >= 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                    break;
                }
            }
        }
    }

    final void quietlyExec() {
        try {
            if (this.status < 0 || !this.exec()) {
                return;
            }
        }
        catch (Throwable throwable) {
            this.setExceptionalCompletion(throwable);
            return;
        }
        this.setCompletion(-1);
    }

    public final ForkJoinTask<V> fork() {
        ((ForkJoinWorkerThread)Thread.currentThread()).pushTask(this);
        return this;
    }

    public final V join() {
        Throwable throwable;
        this.quietlyJoin();
        if (this.status < -1 && (throwable = this.getException()) != null) {
            UNSAFE.throwException(throwable);
        }
        return this.getRawResult();
    }

    public final V invoke() {
        Throwable throwable;
        this.quietlyInvoke();
        if (this.status < -1 && (throwable = this.getException()) != null) {
            UNSAFE.throwException(throwable);
        }
        return this.getRawResult();
    }

    public static void invokeAll(ForkJoinTask<?> forkJoinTask, ForkJoinTask<?> forkJoinTask2) {
        forkJoinTask2.fork();
        forkJoinTask.invoke();
        forkJoinTask2.join();
    }

    public static void invokeAll(ForkJoinTask<?> ... forkJoinTaskArray) {
        ForkJoinTask<?> forkJoinTask;
        int n;
        int n2;
        Throwable throwable = null;
        for (n2 = n = forkJoinTaskArray.length - 1; n2 >= 0; --n2) {
            forkJoinTask = forkJoinTaskArray[n2];
            if (forkJoinTask == null) {
                if (throwable != null) continue;
                throwable = new NullPointerException();
                continue;
            }
            if (n2 != 0) {
                forkJoinTask.fork();
                continue;
            }
            forkJoinTask.quietlyInvoke();
            if (throwable != null || forkJoinTask.status >= -1) continue;
            throwable = forkJoinTask.getException();
        }
        for (n2 = 1; n2 <= n; ++n2) {
            forkJoinTask = forkJoinTaskArray[n2];
            if (forkJoinTask == null) continue;
            if (throwable != null) {
                forkJoinTask.cancel(false);
                continue;
            }
            forkJoinTask.quietlyJoin();
            if (throwable != null || forkJoinTask.status >= -1) continue;
            throwable = forkJoinTask.getException();
        }
        if (throwable != null) {
            UNSAFE.throwException(throwable);
        }
    }

    public static <T extends ForkJoinTask<?>> Collection<T> invokeAll(Collection<T> collection) {
        ForkJoinTask forkJoinTask;
        int n;
        int n2;
        if (!(collection instanceof RandomAccess) || !(collection instanceof List)) {
            ForkJoinTask.invokeAll(collection.toArray(new ForkJoinTask[collection.size()]));
            return collection;
        }
        List list = (List)collection;
        Throwable throwable = null;
        for (n2 = n = list.size() - 1; n2 >= 0; --n2) {
            forkJoinTask = (ForkJoinTask)list.get(n2);
            if (forkJoinTask == null) {
                if (throwable != null) continue;
                throwable = new NullPointerException();
                continue;
            }
            if (n2 != 0) {
                forkJoinTask.fork();
                continue;
            }
            forkJoinTask.quietlyInvoke();
            if (throwable != null || forkJoinTask.status >= -1) continue;
            throwable = forkJoinTask.getException();
        }
        for (n2 = 1; n2 <= n; ++n2) {
            forkJoinTask = (ForkJoinTask)list.get(n2);
            if (forkJoinTask == null) continue;
            if (throwable != null) {
                forkJoinTask.cancel(false);
                continue;
            }
            forkJoinTask.quietlyJoin();
            if (throwable != null || forkJoinTask.status >= -1) continue;
            throwable = forkJoinTask.getException();
        }
        if (throwable != null) {
            UNSAFE.throwException(throwable);
        }
        return collection;
    }

    @Override
    public boolean cancel(boolean bl) {
        this.setCompletion(-2);
        return this.status == -2;
    }

    final void cancelIgnoringExceptions() {
        try {
            this.cancel(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void cancelIfTerminating() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)thread).isTerminating()) {
            try {
                this.cancel(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return this.status == -2;
    }

    public final boolean isCompletedAbnormally() {
        return this.status < -1;
    }

    public final boolean isCompletedNormally() {
        return this.status == -1;
    }

    public final Throwable getException() {
        int n = this.status;
        return n >= -1 ? null : (n == -2 ? new CancellationException() : exceptionMap.get(this));
    }

    public void completeExceptionally(Throwable throwable) {
        this.setExceptionalCompletion(throwable instanceof RuntimeException || throwable instanceof Error ? throwable : new RuntimeException(throwable));
    }

    public void complete(V v) {
        try {
            this.setRawResult(v);
        }
        catch (Throwable throwable) {
            this.setExceptionalCompletion(throwable);
            return;
        }
        this.setCompletion(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get() throws InterruptedException, ExecutionException {
        Serializable serializable;
        int n;
        if (Thread.currentThread() instanceof ForkJoinWorkerThread) {
            this.quietlyJoin();
            n = this.status;
        } else {
            while ((n = this.status) >= 0) {
                serializable = this;
                synchronized (serializable) {
                    if (UNSAFE.compareAndSwapInt(this, statusOffset, n, 1)) {
                        while (this.status >= 0) {
                            this.wait();
                        }
                    }
                }
            }
        }
        if (n < -1) {
            if (n == -2) {
                throw new CancellationException();
            }
            if (n == -3 && (serializable = exceptionMap.get(this)) != null) {
                throw new ExecutionException((Throwable)serializable);
            }
        }
        return this.getRawResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        int n;
        boolean bl;
        boolean bl2;
        ForkJoinPool forkJoinPool;
        block19: {
            long l2;
            Thread thread = Thread.currentThread();
            if (thread instanceof ForkJoinWorkerThread) {
                ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
                if (this.status >= 0 && forkJoinWorkerThread.unpushTask(this)) {
                    this.quietlyExec();
                }
                forkJoinPool = forkJoinWorkerThread.pool;
            } else {
                forkJoinPool = null;
            }
            bl2 = false;
            bl = false;
            long l3 = timeUnit.toNanos(l);
            do {
                if (forkJoinPool == null && Thread.interrupted()) {
                    bl2 = true;
                    break block19;
                }
                n = this.status;
                if (n < 0) break block19;
            } while (!UNSAFE.compareAndSwapInt(this, statusOffset, n, 1));
            long l4 = System.nanoTime();
            while (this.status >= 0 && (l2 = l3 - (System.nanoTime() - l4)) > 0L) {
                if (forkJoinPool != null && !bl) {
                    bl = forkJoinPool.tryDecrementRunningCount();
                    continue;
                }
                long l5 = l2 / 1000000L;
                int n2 = (int)(l2 % 1000000L);
                try {
                    ForkJoinTask forkJoinTask = this;
                    synchronized (forkJoinTask) {
                        if (this.status >= 0) {
                            this.wait(l5, n2);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (forkJoinPool != null) {
                        this.cancelIfTerminating();
                        continue;
                    }
                    bl2 = true;
                    break;
                }
            }
        }
        if (forkJoinPool != null && bl) {
            forkJoinPool.incrementRunningCount();
        }
        if (bl2) {
            throw new InterruptedException();
        }
        n = this.status;
        if (n != -1) {
            Throwable throwable;
            if (n == -2) {
                throw new CancellationException();
            }
            if (n == -3 && (throwable = exceptionMap.get(this)) != null) {
                throw new ExecutionException(throwable);
            }
            throw new TimeoutException();
        }
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            if (this.status >= 0) {
                if (forkJoinWorkerThread.unpushTask(this)) {
                    boolean bl;
                    try {
                        bl = this.exec();
                    }
                    catch (Throwable throwable) {
                        this.setExceptionalCompletion(throwable);
                        return;
                    }
                    if (bl) {
                        this.setCompletion(-1);
                        return;
                    }
                }
                forkJoinWorkerThread.joinTask(this);
            }
        } else {
            this.externalAwaitDone();
        }
    }

    public final void quietlyInvoke() {
        if (this.status >= 0) {
            boolean bl;
            try {
                bl = this.exec();
            }
            catch (Throwable throwable) {
                this.setExceptionalCompletion(throwable);
                return;
            }
            if (bl) {
                this.setCompletion(-1);
            } else {
                this.quietlyJoin();
            }
        }
    }

    public static void helpQuiesce() {
        ((ForkJoinWorkerThread)Thread.currentThread()).helpQuiescePool();
    }

    public void reinitialize() {
        if (this.status == -3) {
            exceptionMap.remove(this);
        }
        this.status = 0;
    }

    public static ForkJoinPool getPool() {
        Thread thread = Thread.currentThread();
        return thread instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)thread).pool : null;
    }

    public static boolean inForkJoinPool() {
        return Thread.currentThread() instanceof ForkJoinWorkerThread;
    }

    public boolean tryUnfork() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).unpushTask(this);
    }

    public static int getQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getQueueSize();
    }

    public static int getSurplusQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getEstimatedSurplusTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).peekTask();
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollLocalTask();
    }

    protected static ForkJoinTask<?> pollTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollTask();
    }

    public static ForkJoinTask<?> adapt(Runnable runnable) {
        return new AdaptedRunnable<Object>(runnable, null);
    }

    public static <T> ForkJoinTask<T> adapt(Runnable runnable, T t) {
        return new AdaptedRunnable<T>(runnable, t);
    }

    public static <T> ForkJoinTask<T> adapt(Callable<? extends T> callable) {
        return new AdaptedCallable<T>(callable);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object != null) {
            this.setExceptionalCompletion((Throwable)object);
        }
    }

    private static long objectFieldOffset(String string, Class<?> clazz) {
        try {
            return UNSAFE.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            noSuchFieldError.initCause(noSuchFieldException);
            throw noSuchFieldError;
        }
    }

    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedCallable(Callable<? extends T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = callable;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T t) {
            this.result = t;
        }

        @Override
        public boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        final T resultOnCompletion;
        T result;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnable(Runnable runnable, T t) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
            this.resultOnCompletion = t;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T t) {
            this.result = t;
        }

        @Override
        public boolean exec() {
            this.runnable.run();
            this.result = this.resultOnCompletion;
            return true;
        }

        @Override
        public void run() {
            this.invoke();
        }
    }
}

