/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.rules.ReadAccessFilteringRule;
import com.intellij.usages.impl.rules.WriteAccessFilteringRule;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class UsageFilteringRuleProviderImpl
implements UsageFilteringRuleProvider {
    private final ReadWriteState myReadWriteState = new ReadWriteState();

    @Override
    @NotNull
    public UsageFilteringRule[] getActiveRules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageFilteringRuleProviderImpl.getActiveRules must not be null");
        }
        ArrayList<UsageFilteringRule> rules = new ArrayList<UsageFilteringRule>();
        if (!this.myReadWriteState.isShowReadAccess()) {
            rules.add(new ReadAccessFilteringRule());
        }
        if (!this.myReadWriteState.isShowWriteAccess()) {
            rules.add(new WriteAccessFilteringRule());
        }
        UsageFilteringRule[] usageFilteringRuleArray = rules.toArray(new UsageFilteringRule[rules.size()]);
        if (usageFilteringRuleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageFilteringRuleProviderImpl.getActiveRules must not return null");
        }
        return usageFilteringRuleArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public AnAction[] createFilteringActions(@NotNull UsageView view) {
        AnAction[] anActionArray;
        if (view == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageFilteringRuleProviderImpl.createFilteringActions must not be null");
        }
        UsageViewImpl impl = (UsageViewImpl)view;
        if (!view.getPresentation().isCodeUsages()) {
            anActionArray = AnAction.EMPTY_ARRAY;
            if (AnAction.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageFilteringRuleProviderImpl.createFilteringActions must not return null");
            return anActionArray;
        }
        final JComponent component = view.getComponent();
        final ShowReadAccessUsagesAction read = new ShowReadAccessUsagesAction();
        read.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(82, 128)), component);
        final ShowWriteAccessUsagesAction write = new ShowWriteAccessUsagesAction();
        write.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(87, 128)), component);
        impl.scheduleDisposeOnClose(new Disposable(){

            public void dispose() {
                read.unregisterCustomShortcutSet(component);
                write.unregisterCustomShortcutSet(component);
            }
        });
        anActionArray = new AnAction[]{read, write};
        if (anActionArray != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageFilteringRuleProviderImpl.createFilteringActions must not return null");
    }

    private class ShowWriteAccessUsagesAction
    extends ToggleAction
    implements DumbAware {
        private ShowWriteAccessUsagesAction() {
            super(UsageViewBundle.message("action.show.write.access", new Object[0]), null, IconLoader.getIcon((String)"/actions/showWriteAccess.png"));
        }

        @Override
        public boolean isSelected(AnActionEvent e) {
            return UsageFilteringRuleProviderImpl.this.myReadWriteState.isShowWriteAccess();
        }

        @Override
        public void setSelected(AnActionEvent e, boolean state) {
            UsageFilteringRuleProviderImpl.this.myReadWriteState.setShowWriteAccess(state);
            Project project = PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            ((Runnable)project.getMessageBus().syncPublisher(UsageFilteringRuleProvider.RULES_CHANGED)).run();
        }
    }

    private class ShowReadAccessUsagesAction
    extends ToggleAction
    implements DumbAware {
        private ShowReadAccessUsagesAction() {
            super(UsageViewBundle.message("action.show.read.access", new Object[0]), null, IconLoader.getIcon((String)"/actions/showReadAccess.png"));
        }

        @Override
        public boolean isSelected(AnActionEvent e) {
            return UsageFilteringRuleProviderImpl.this.myReadWriteState.isShowReadAccess();
        }

        @Override
        public void setSelected(AnActionEvent e, boolean state) {
            UsageFilteringRuleProviderImpl.this.myReadWriteState.setShowReadAccess(state);
            Project project = PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            ((Runnable)project.getMessageBus().syncPublisher(UsageFilteringRuleProvider.RULES_CHANGED)).run();
        }
    }

    private static final class ReadWriteState {
        private boolean myShowReadAccess = true;
        private boolean myShowWriteAccess = true;

        private ReadWriteState() {
        }

        public boolean isShowReadAccess() {
            return this.myShowReadAccess;
        }

        public void setShowReadAccess(boolean showReadAccess) {
            this.myShowReadAccess = showReadAccess;
            if (!showReadAccess) {
                this.myShowWriteAccess = true;
            }
        }

        public boolean isShowWriteAccess() {
            return this.myShowWriteAccess;
        }

        public void setShowWriteAccess(boolean showWriteAccess) {
            this.myShowWriteAccess = showWriteAccess;
            if (!showWriteAccess) {
                this.myShowReadAccess = true;
            }
        }
    }
}

