/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.Condition;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectJdkTable {
    public static Topic<Listener> JDK_TABLE_TOPIC = Topic.create((String)"Project JDK table", Listener.class);

    public static ProjectJdkTable getInstance() {
        return ServiceManager.getService(ProjectJdkTable.class);
    }

    @Nullable
    public abstract Sdk findJdk(String var1);

    @Nullable
    public abstract Sdk findJdk(String var1, String var2);

    public abstract Sdk[] getAllJdks();

    public abstract List<Sdk> getSdksOfType(SdkType var1);

    @Nullable
    public abstract Sdk findMostRecentSdkOfType(SdkType var1);

    @Nullable
    public abstract Sdk findMostRecentSdk(Condition<Sdk> var1);

    public abstract void addJdk(Sdk var1);

    public abstract void removeJdk(Sdk var1);

    public abstract void updateJdk(Sdk var1, Sdk var2);

    public abstract void addListener(Listener var1);

    public abstract void removeListener(Listener var1);

    public abstract SdkType getDefaultSdkType();

    public abstract Sdk createSdk(String var1, SdkType var2);

    public static interface Listener
    extends EventListener {
        public void jdkAdded(Sdk var1);

        public void jdkRemoved(Sdk var1);

        public void jdkNameChanged(Sdk var1, String var2);
    }
}

