/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Editor
extends UserDataHolder {
    public static final Editor[] EMPTY_ARRAY = new Editor[0];

    @NotNull
    public Document getDocument();

    public boolean isViewer();

    @NotNull
    public JComponent getComponent();

    @NotNull
    public JComponent getContentComponent();

    @NotNull
    public SelectionModel getSelectionModel();

    @NotNull
    public MarkupModel getMarkupModel();

    @NotNull
    public FoldingModel getFoldingModel();

    @NotNull
    public ScrollingModel getScrollingModel();

    @NotNull
    public CaretModel getCaretModel();

    @NotNull
    public EditorSettings getSettings();

    @NotNull
    public EditorColorsScheme getColorsScheme();

    public int getLineHeight();

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition var1);

    public int logicalPositionToOffset(@NotNull LogicalPosition var1);

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition var1);

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition var1);

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition var1);

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int var1);

    @NotNull
    public VisualPosition offsetToVisualPosition(int var1);

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point var1);

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point var1);

    public void addEditorMouseListener(@NotNull EditorMouseListener var1);

    public void removeEditorMouseListener(@NotNull EditorMouseListener var1);

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener var1);

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener var1);

    public boolean isDisposed();

    @Nullable
    public Project getProject();

    public boolean isInsertMode();

    public boolean isColumnMode();

    public boolean isOneLineMode();

    @NotNull
    public EditorGutter getGutter();

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent var1);

    public void setHeaderComponent(@Nullable JComponent var1);

    public boolean hasHeaderComponent();

    @Nullable
    public JComponent getHeaderComponent();

    public IndentsModel getIndentsModel();
}

