/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PresentationData
implements ItemPresentation,
ComparableObject {
    protected final CopyOnWriteArrayList<PresentableNodeDescriptor.ColoredFragment> myColoredText = ContainerUtil.createEmptyCOWList();
    private Icon myClosedIcon;
    private Icon myOpenIcon;
    private String myLocationString;
    private String myPresentableText;
    private String myTooltip;
    private TextAttributesKey myAttributesKey;
    private Color myForcedTextForeground;
    private Font myFont;
    private boolean myChanged;

    public PresentationData(String presentableText, String locationString, Icon openIcon, Icon closedIcon, @Nullable TextAttributesKey attributesKey) {
        this.myClosedIcon = closedIcon;
        this.myLocationString = locationString;
        this.myOpenIcon = openIcon;
        this.myPresentableText = presentableText;
        this.myAttributesKey = attributesKey;
    }

    public PresentationData() {
    }

    @Override
    public Icon getIcon(boolean open) {
        return open ? this.myOpenIcon : this.myClosedIcon;
    }

    @Nullable
    public Color getForcedTextForeground() {
        return this.myForcedTextForeground;
    }

    public void setForcedTextForeground(@Nullable Color forcedTextForeground) {
        this.myForcedTextForeground = forcedTextForeground;
    }

    @Override
    public String getLocationString() {
        return this.myLocationString;
    }

    @Override
    public String getPresentableText() {
        return this.myPresentableText;
    }

    public void setClosedIcon(Icon closedIcon) {
        this.myClosedIcon = closedIcon;
    }

    public void setLocationString(String locationString) {
        this.myLocationString = locationString;
    }

    public void setOpenIcon(Icon openIcon) {
        this.myOpenIcon = openIcon;
    }

    public void setPresentableText(String presentableText) {
        this.myPresentableText = presentableText;
    }

    public void setIcons(Icon icon) {
        this.setClosedIcon(icon);
        this.setOpenIcon(icon);
    }

    public void updateFrom(ItemPresentation presentation) {
        this.setClosedIcon(presentation.getIcon(false));
        this.setOpenIcon(presentation.getIcon(true));
        this.setPresentableText(presentation.getPresentableText());
        this.setLocationString(presentation.getLocationString());
        this.setAttributesKey(presentation.getTextAttributesKey());
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return this.myAttributesKey;
    }

    public void setAttributesKey(TextAttributesKey attributesKey) {
        this.myAttributesKey = attributesKey;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(String tooltip) {
        this.myTooltip = tooltip;
    }

    public boolean isChanged() {
        return this.myChanged;
    }

    public void setChanged(boolean changed) {
        this.myChanged = changed;
    }

    @NotNull
    public List<PresentableNodeDescriptor.ColoredFragment> getColoredText() {
        CopyOnWriteArrayList<PresentableNodeDescriptor.ColoredFragment> copyOnWriteArrayList = this.myColoredText;
        if (copyOnWriteArrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/PresentationData.getColoredText must not return null");
        }
        return copyOnWriteArrayList;
    }

    public void addText(PresentableNodeDescriptor.ColoredFragment coloredFragment) {
        this.myColoredText.add(coloredFragment);
    }

    public void addText(String text, SimpleTextAttributes attributes) {
        this.myColoredText.add(new PresentableNodeDescriptor.ColoredFragment(text, attributes));
    }

    public void clearText() {
        this.myColoredText.clear();
    }

    public void clear() {
        this.myOpenIcon = null;
        this.myClosedIcon = null;
        this.clearText();
        this.myAttributesKey = null;
        this.myFont = null;
        this.myForcedTextForeground = null;
        this.myLocationString = null;
        this.myPresentableText = null;
        this.myTooltip = null;
        this.myChanged = false;
    }

    public Object[] getEqualityObjects() {
        return new Object[]{this.myOpenIcon, this.myClosedIcon, this.myColoredText, this.myAttributesKey, this.myFont, this.myForcedTextForeground, this.myPresentableText, this.myLocationString};
    }

    public int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    public boolean equals(Object obj) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)obj);
    }

    public void copyFrom(PresentationData from) {
        if (from == this) {
            return;
        }
        this.myAttributesKey = from.myAttributesKey;
        this.myClosedIcon = from.myClosedIcon;
        this.clearText();
        this.myColoredText.addAll(from.myColoredText);
        this.myFont = from.myFont;
        this.myForcedTextForeground = from.myForcedTextForeground;
        this.myLocationString = from.myLocationString;
        this.myOpenIcon = from.myOpenIcon;
        this.myPresentableText = from.myPresentableText;
        this.myTooltip = from.myTooltip;
    }

    public void applyFrom(PresentationData from) {
        this.myAttributesKey = this.getValue(this.myAttributesKey, from.myAttributesKey);
        this.myClosedIcon = this.getValue(this.myClosedIcon, from.myClosedIcon);
        if (this.myColoredText.size() == 0) {
            this.myColoredText.addAll(from.myColoredText);
        }
        this.myFont = this.getValue(this.myFont, from.myFont);
        this.myForcedTextForeground = this.getValue(this.myForcedTextForeground, from.myForcedTextForeground);
        this.myLocationString = this.getValue(this.myLocationString, from.myLocationString);
        this.myOpenIcon = this.getValue(this.myOpenIcon, from.myOpenIcon);
        this.myPresentableText = this.getValue(this.myPresentableText, from.myPresentableText);
        this.myTooltip = this.getValue(this.myTooltip, from.myTooltip);
    }

    private <T> T getValue(T ownValue, T fromValue) {
        return ownValue != null ? ownValue : fromValue;
    }
}

