/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.Nullable;

public class EvaluateException
extends Exception {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.EvaluateException");
    private ObjectReference myTargetException;

    public EvaluateException(String message) {
        super(message);
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
    }

    public EvaluateException(String msg, Throwable th) {
        super(msg, th);
        if (th instanceof EvaluateException) {
            this.myTargetException = ((EvaluateException)th).getExceptionFromTargetVM();
        } else if (th instanceof InvocationException) {
            InvocationException invocationException = (InvocationException)th;
            this.myTargetException = invocationException.exception();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(msg);
        }
    }

    @Nullable
    public ObjectReference getExceptionFromTargetVM() {
        return this.myTargetException;
    }

    public void setTargetException(ObjectReference targetException) {
        this.myTargetException = targetException;
    }
}

