/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.DummyIdentifierPatcher;
import com.intellij.codeInsight.completion.FileCopyPatcher;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompletionInitializationContext {
    public static final OffsetKey START_OFFSET = OffsetKey.create("startOffset", false);
    public static final OffsetKey SELECTION_END_OFFSET = OffsetKey.create("selectionEnd");
    public static final OffsetKey IDENTIFIER_END_OFFSET = OffsetKey.create("identifierEnd");
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz";
    private final Editor myEditor;
    private final PsiFile myFile;
    private final CompletionType myCompletionType;
    private final OffsetMap myOffsetMap;
    private FileCopyPatcher myFileCopyPatcher = new DummyIdentifierPatcher("IntellijIdeaRulezzz ");

    public CompletionInitializationContext(Editor editor, PsiFile file, CompletionType completionType) {
        this.myEditor = editor;
        this.myFile = file;
        this.myCompletionType = completionType;
        this.myOffsetMap = new OffsetMap(editor.getDocument());
        int caretOffset = editor.getCaretModel().getOffset();
        SelectionModel selectionModel = editor.getSelectionModel();
        this.myOffsetMap.addOffset(START_OFFSET, selectionModel.hasSelection() ? selectionModel.getSelectionStart() : caretOffset);
        int selectionEndOffset = selectionModel.hasSelection() ? selectionModel.getSelectionEnd() : caretOffset;
        this.myOffsetMap.addOffset(SELECTION_END_OFFSET, selectionEndOffset);
        this.myOffsetMap.addOffset(IDENTIFIER_END_OFFSET, CompletionInitializationContext.findIdentifierEnd(file, selectionEndOffset));
    }

    private static int findIdentifierEnd(PsiFile file, int selectionEndOffset) {
        int idEnd;
        try {
            PsiReference reference = file.findReferenceAt(selectionEndOffset);
            if (reference != null) {
                return reference.getElement().getTextRange().getStartOffset() + reference.getRangeInElement().getEndOffset();
            }
        }
        catch (IndexNotReadyException ignored) {
            // empty catch block
        }
        String text = file.getText();
        for (idEnd = selectionEndOffset; idEnd < text.length() && Character.isJavaIdentifierPart(text.charAt(idEnd)); ++idEnd) {
        }
        return idEnd;
    }

    public void setFileCopyPatcher(@NotNull FileCopyPatcher fileCopyPatcher) {
        if (fileCopyPatcher == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionInitializationContext.setFileCopyPatcher must not be null");
        }
        this.myFileCopyPatcher = fileCopyPatcher;
    }

    @NotNull
    public FileCopyPatcher getFileCopyPatcher() {
        FileCopyPatcher fileCopyPatcher = this.myFileCopyPatcher;
        if (fileCopyPatcher == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionInitializationContext.getFileCopyPatcher must not return null");
        }
        return fileCopyPatcher;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionInitializationContext.getEditor must not return null");
        }
        return editor;
    }

    @NotNull
    public CompletionType getCompletionType() {
        CompletionType completionType = this.myCompletionType;
        if (completionType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionInitializationContext.getCompletionType must not return null");
        }
        return completionType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myFile.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionInitializationContext.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionInitializationContext.getFile must not return null");
        }
        return psiFile;
    }

    @NotNull
    public OffsetMap getOffsetMap() {
        OffsetMap offsetMap = this.myOffsetMap;
        if (offsetMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionInitializationContext.getOffsetMap must not return null");
        }
        return offsetMap;
    }

    public int getStartOffset() {
        return this.myOffsetMap.getOffset(START_OFFSET);
    }

    public int getSelectionEndOffset() {
        return this.myOffsetMap.getOffset(SELECTION_END_OFFSET);
    }

    public int getIdentifierEndOffset() {
        return this.myOffsetMap.getOffset(IDENTIFIER_END_OFFSET);
    }
}

