/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitBranch;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import org.jetbrains.annotations.Nullable;

public class GitPushUtils {
    private GitPushUtils() {
    }

    @Nullable
    public static GitLineHandler preparePush(Project project, VirtualFile vcsRoot) throws VcsException {
        GitBranch current = GitBranch.current(project, vcsRoot);
        if (current == null) {
            return null;
        }
        String remote = current.getTrackedRemoteName(project, vcsRoot);
        if (remote == null) {
            return null;
        }
        String tracked = current.getTrackedBranchName(project, vcsRoot);
        if (tracked == null) {
            return null;
        }
        GitLineHandler rc = new GitLineHandler(project, vcsRoot, GitCommand.PUSH);
        rc.addParameters("-v", remote, current.getFullName() + ":" + tracked);
        GitPushUtils.trackPushRejectedAsError(rc, "Rejected push (" + vcsRoot.getPresentableUrl() + "): ");
        return rc;
    }

    public static void trackPushRejectedAsError(final GitLineHandler handler, final String prefix) {
        handler.addLineListener(new GitLineHandlerAdapter(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType == ProcessOutputTypes.STDERR && line.startsWith(" ! [")) {
                    handler.addError(new VcsException(prefix + line));
                }
            }
        });
    }
}

