/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.radComponents.RadBorderLayoutManager;
import com.intellij.uiDesigner.radComponents.RadBoxLayoutManager;
import com.intellij.uiDesigner.radComponents.RadCardLayoutManager;
import com.intellij.uiDesigner.radComponents.RadFlowLayoutManager;
import com.intellij.uiDesigner.radComponents.RadFormLayoutManager;
import com.intellij.uiDesigner.radComponents.RadGridBagLayoutManager;
import com.intellij.uiDesigner.radComponents.RadGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.radComponents.RadSwingGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadXYLayoutManager;
import com.intellij.util.ArrayUtil;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LayoutManagerRegistry {
    @NonNls
    private static final Map<String, Class<? extends RadLayoutManager>> ourLayoutManagerRegistry = new HashMap<String, Class<? extends RadLayoutManager>>();
    @NonNls
    private static final Map<Class, Class<? extends RadLayoutManager>> ourLayoutManagerClassRegistry = new HashMap<Class, Class<? extends RadLayoutManager>>();
    @NonNls
    private static final Map<String, String> ourLayoutManagerDisplayNames = new HashMap<String, String>();

    private LayoutManagerRegistry() {
    }

    public static String[] getLayoutManagerNames() {
        Object[] layoutManagerNames = ArrayUtil.toStringArray(ourLayoutManagerRegistry.keySet());
        Arrays.sort(layoutManagerNames);
        return layoutManagerNames;
    }

    public static String[] getNonDeprecatedLayoutManagerNames() {
        ArrayList<String> layoutManagerNames = new ArrayList<String>();
        for (String name : ourLayoutManagerRegistry.keySet()) {
            if (name.equals("XYLayout")) continue;
            layoutManagerNames.add(name);
        }
        Collections.sort(layoutManagerNames);
        return ArrayUtil.toStringArray(layoutManagerNames);
    }

    public static String getLayoutManagerDisplayName(String name) {
        if (ourLayoutManagerDisplayNames.containsKey(name)) {
            return ourLayoutManagerDisplayNames.get(name);
        }
        return name;
    }

    public static RadLayoutManager createLayoutManager(String name) throws IllegalAccessException, InstantiationException {
        Class<? extends RadLayoutManager> cls = ourLayoutManagerRegistry.get(name);
        if (cls == null) {
            throw new IllegalArgumentException("Unknown layout manager " + name);
        }
        return cls.newInstance();
    }

    @Nullable
    public static RadLayoutManager createFromLayout(LayoutManager layout) {
        if (layout == null) {
            return null;
        }
        return LayoutManagerRegistry.createFromLayoutClass(layout.getClass());
    }

    @Nullable
    private static RadLayoutManager createFromLayoutClass(Class aClass) {
        for (Map.Entry<Class, Class<? extends RadLayoutManager>> e : ourLayoutManagerClassRegistry.entrySet()) {
            if (!e.getKey().getName().equals(aClass.getName())) continue;
            try {
                return e.getValue().newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (aClass.getSuperclass() != null) {
            return LayoutManagerRegistry.createFromLayoutClass(aClass.getSuperclass());
        }
        return null;
    }

    public static boolean isKnownLayoutClass(String className) {
        for (Class c : ourLayoutManagerClassRegistry.keySet()) {
            if (!c.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static RadLayoutManager createDefaultGridLayoutManager(Project project) {
        String defaultLayoutManager = GuiDesignerConfiguration.getInstance((Project)project).DEFAULT_LAYOUT_MANAGER;
        if (defaultLayoutManager.equals("GridBagLayout")) {
            return new RadGridBagLayoutManager();
        }
        if (defaultLayoutManager.equals("FormLayout")) {
            return new RadFormLayoutManager();
        }
        return new RadGridLayoutManager();
    }

    static {
        ourLayoutManagerRegistry.put("GridLayoutManager", RadGridLayoutManager.class);
        ourLayoutManagerRegistry.put("GridBagLayout", RadGridBagLayoutManager.class);
        ourLayoutManagerRegistry.put("BorderLayout", RadBorderLayoutManager.class);
        ourLayoutManagerRegistry.put("FlowLayout", RadFlowLayoutManager.class);
        ourLayoutManagerRegistry.put("XYLayout", RadXYLayoutManager.class);
        ourLayoutManagerRegistry.put("CardLayout", RadCardLayoutManager.class);
        ourLayoutManagerRegistry.put("FormLayout", RadFormLayoutManager.class);
        ourLayoutManagerClassRegistry.put(BorderLayout.class, RadBorderLayoutManager.class);
        ourLayoutManagerClassRegistry.put(GridBagLayout.class, RadGridBagLayoutManager.class);
        ourLayoutManagerClassRegistry.put(FlowLayout.class, RadFlowLayoutManager.class);
        ourLayoutManagerClassRegistry.put(GridLayout.class, RadSwingGridLayoutManager.class);
        ourLayoutManagerClassRegistry.put(BoxLayout.class, RadBoxLayoutManager.class);
        ourLayoutManagerClassRegistry.put(CardLayout.class, RadCardLayoutManager.class);
        ourLayoutManagerClassRegistry.put(FormLayout.class, RadFormLayoutManager.class);
        ourLayoutManagerDisplayNames.put("GridLayoutManager", "GridLayoutManager (IntelliJ)");
        ourLayoutManagerDisplayNames.put("FormLayout", "FormLayout (JGoodies)");
    }
}

