/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.compiler.impl.StateCache;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.LwRootContainer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.NonNls;

final class BindingsCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.make.BindingsCache");
    @NonNls
    private static final String BINDINGS_FILE_NAME = "formbinding.dat";
    private StateCache<MyState> myCache;

    public BindingsCache(Project project) {
        File cacheStoreDirectory = CompilerPaths.getCacheStoreDirectory((Project)project);
        try {
            if (cacheStoreDirectory != null) {
                FileUtil.createParentDirs((File)cacheStoreDirectory);
                this.myCache = BindingsCache.createCache(cacheStoreDirectory);
            } else {
                this.myCache = null;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            for (File file : cacheStoreDirectory.listFiles()) {
                if (!file.getName().startsWith(BINDINGS_FILE_NAME)) continue;
                FileUtil.delete((File)file);
            }
            try {
                this.myCache = BindingsCache.createCache(cacheStoreDirectory);
            }
            catch (IOException e1) {
                LOG.info((Throwable)e1);
                this.myCache = null;
            }
        }
    }

    private static StateCache<MyState> createCache(File cacheStoreDirectory) throws IOException {
        return new StateCache<MyState>(new File(cacheStoreDirectory, BINDINGS_FILE_NAME)){

            public MyState read(DataInput stream) throws IOException {
                return new MyState(stream.readLong(), stream.readUTF());
            }

            public void write(MyState myState, DataOutput out) throws IOException {
                out.writeLong(myState.getFormTimeStamp());
                out.writeUTF(myState.getClassName());
            }
        };
    }

    public String getBoundClassName(VirtualFile formFile) throws Exception {
        String classToBind = this.getSavedBinding(formFile);
        if (classToBind == null) {
            Document doc = FileDocumentManager.getInstance().getDocument(formFile);
            LwRootContainer rootContainer = Utils.getRootContainer((String)doc.getText(), null);
            classToBind = rootContainer.getClassToBind();
        }
        if (classToBind != null) {
            this.updateCache(formFile, classToBind);
        }
        return classToBind;
    }

    private String getSavedBinding(VirtualFile formFile) {
        if (this.myCache != null) {
            try {
                String formUrl = formFile.getUrl();
                MyState state = (MyState)this.myCache.getState(formUrl);
                if (state != null && formFile.getTimeStamp() == state.getFormTimeStamp()) {
                    return state.getClassName();
                }
            }
            catch (IOException e) {
                this.myCache.wipe();
            }
        }
        return null;
    }

    private void updateCache(VirtualFile formFile, String classToBind) {
        if (this.myCache != null) {
            String url = formFile.getUrl();
            MyState state = new MyState(formFile.getTimeStamp(), classToBind);
            try {
                this.myCache.update(url, (Object)state);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.myCache.wipe();
                try {
                    this.myCache.update(url, (Object)state);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
    }

    public void close() {
        try {
            this.myCache.close();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static final class MyState
    implements Serializable {
        private final long myFormTimeStamp;
        private final String myClassName;

        public MyState(long formTimeStamp, String className) {
            this.myFormTimeStamp = formTimeStamp;
            this.myClassName = className;
        }

        public long getFormTimeStamp() {
            return this.myFormTimeStamp;
        }

        public String getClassName() {
            return this.myClassName;
        }
    }
}

