/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.module;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;

public class PluginModuleBuilder
extends JavaModuleBuilder {
    @NonNls
    private static final String META_INF = "META-INF";
    @NonNls
    private static final String PLUGIN_XML = "plugin.xml";

    public ModuleType getModuleType() {
        return PluginModuleType.getInstance();
    }

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        super.setupRootModel(rootModel);
        String defaultPluginXMLLocation = this.getModuleFileDirectory() + '/' + META_INF + '/' + PLUGIN_XML;
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(defaultPluginXMLLocation);
        if (file == null) {
            final Module module = rootModel.getModule();
            StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    PluginBuildConfiguration buildConfiguration = PluginBuildConfiguration.getInstance(module);
                    buildConfiguration.createPluginXmlIfNotExist();
                }
            });
        }
    }

    public boolean isSuitableSdk(Sdk sdk) {
        return sdk.getSdkType() == IdeaJdk.getInstance();
    }
}

