/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemPropertiesInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("AccessOfSystemProperties" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/SystemPropertiesInspection.getID must not return null");
        }
        return "AccessOfSystemProperties";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("system.properties.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/SystemPropertiesInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        boolean isGetSystemProperty = (Boolean)infos[0];
        boolean isIntegerGetInteger = (Boolean)infos[1];
        if (isGetSystemProperty) {
            string = InspectionGadgetsBundle.message("system.set.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/security/SystemPropertiesInspection.buildErrorString must not return null");
            return string;
        }
        if (isIntegerGetInteger) {
            string = InspectionGadgetsBundle.message("system.properties.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/security/SystemPropertiesInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("system.properties.problem.descriptor1", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/security/SystemPropertiesInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemSetSecurityManagerVisitor();
    }

    private static class SystemSetSecurityManagerVisitor
    extends BaseInspectionVisitor {
        private SystemSetSecurityManagerVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/security/SystemPropertiesInspection$SystemSetSecurityManagerVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            boolean isGetSystemProperty = SystemSetSecurityManagerVisitor.isGetSystemProperty(expression);
            boolean isIntegerGetInteger = SystemSetSecurityManagerVisitor.isIntegerGetInteger(expression);
            boolean isBooleanGetBoolean = SystemSetSecurityManagerVisitor.isBooleanGetBoolean(expression);
            if (!(isGetSystemProperty || isIntegerGetInteger || isBooleanGetBoolean)) {
                return;
            }
            this.registerMethodCallError(expression, isGetSystemProperty, isIntegerGetInteger);
        }

        private static boolean isGetSystemProperty(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("getProperty".equals(methodName) || "getProperties".equals(methodName) || "setProperty".equals(methodName) || "setProperties".equals(methodName) || "clearProperties".equals(methodName))) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.System".equals(className);
        }

        private static boolean isIntegerGetInteger(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getInteger".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.Integer".equals(className);
        }

        private static boolean isBooleanGetBoolean(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getBoolean".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.Boolean".equals(className);
        }
    }
}

