/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk15;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryUnboxingInspection
extends BaseInspection {
    @NonNls
    static final Map<String, String> s_unboxingMethods = new HashMap<String, String>(9);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.unboxing.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/UnnecessaryUnboxingInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.unboxing.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/UnnecessaryUnboxingInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnboxingVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryUnboxingFix();
    }

    static {
        s_unboxingMethods.put("java.lang.Integer", "intValue");
        s_unboxingMethods.put("java.lang.Short", "shortValue");
        s_unboxingMethods.put("java.lang.Boolean", "booleanValue");
        s_unboxingMethods.put("java.lang.Long", "longValue");
        s_unboxingMethods.put("java.lang.Byte", "byteValue");
        s_unboxingMethods.put("java.lang.Float", "floatValue");
        s_unboxingMethods.put("java.lang.Long", "longValue");
        s_unboxingMethods.put("java.lang.Double", "doubleValue");
        s_unboxingMethods.put("java.lang.Character", "charValue");
    }

    private static class UnnecessaryUnboxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnboxingVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiMethodCallExpression methodCallExpression;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                return;
            }
            if (!UnnecessaryUnboxingVisitor.isUnboxingExpression((PsiExpression)expression)) {
                return;
            }
            PsiExpression containingExpression = UnnecessaryUnboxingVisitor.getContainingExpression((PsiElement)expression);
            if (containingExpression instanceof PsiTypeCastExpression) {
                return;
            }
            if (UnnecessaryUnboxingVisitor.isPossibleObjectComparison(expression, containingExpression)) {
                return;
            }
            if (containingExpression instanceof PsiConditionalExpression) {
                PsiType type;
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)containingExpression;
                PsiExpression thenExpression = conditionalExpression.getThenExpression();
                if (thenExpression == null) {
                    return;
                }
                PsiExpression elseExpression = conditionalExpression.getElseExpression();
                if (elseExpression == null) {
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)thenExpression, (PsiElement)expression, (boolean)false) ? !((type = elseExpression.getType()) instanceof PsiPrimitiveType) : PsiTreeUtil.isAncestor((PsiElement)elseExpression, (PsiElement)expression, (boolean)false) && !((type = thenExpression.getType()) instanceof PsiPrimitiveType)) {
                    return;
                }
            }
            if (containingExpression instanceof PsiMethodCallExpression && !UnnecessaryUnboxingVisitor.isSameMethodCalledWithoutUnboxing(methodCallExpression = (PsiMethodCallExpression)containingExpression, expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean isPossibleObjectComparison(PsiMethodCallExpression expression, PsiExpression containingExpression) {
            if (!(containingExpression instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)containingExpression;
            if (!ComparisonUtils.isEqualityComparison(binaryExpression)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return true;
            }
            if (expression == lhs && (!(rhs.getType() instanceof PsiPrimitiveType) || UnnecessaryUnboxingVisitor.isUnboxingExpression(rhs))) {
                return true;
            }
            return expression == rhs && (!(lhs.getType() instanceof PsiPrimitiveType) || UnnecessaryUnboxingVisitor.isUnboxingExpression(lhs));
        }

        private static boolean isUnboxingExpression(PsiExpression expression) {
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return false;
            }
            String qualifierTypeName = qualifierType.getCanonicalText();
            if (!s_unboxingMethods.containsKey(qualifierTypeName)) {
                return false;
            }
            String methodName = methodExpression.getReferenceName();
            String unboxingMethod = s_unboxingMethods.get(qualifierTypeName);
            return unboxingMethod.equals(methodName);
        }

        private static boolean isSameMethodCalledWithoutUnboxing(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull PsiMethodCallExpression unboxingExpression) {
            PsiMethod[] methods;
            if (methodCallExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor.isSameMethodCalledWithoutUnboxing must not be null");
            }
            if (unboxingExpression == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor.isSameMethodCalledWithoutUnboxing must not be null");
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement element = methodExpression.resolve();
            if (!(element instanceof PsiMethod)) {
                return false;
            }
            PsiMethod originalMethod = (PsiMethod)element;
            String name = originalMethod.getName();
            PsiClass containingClass = originalMethod.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            PsiType[] types = new PsiType[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                PsiExpression expression = expressions[i];
                PsiType type = expression.getType();
                if (unboxingExpression.equals(expression)) {
                    if (!(type instanceof PsiPrimitiveType)) {
                        return false;
                    }
                    PsiPrimitiveType primitiveType = (PsiPrimitiveType)type;
                    types[i] = primitiveType.getBoxedType((PsiElement)unboxingExpression);
                    continue;
                }
                types[i] = type;
            }
            for (PsiMethod method : methods = containingClass.findMethodsByName(name, true)) {
                if (originalMethod.equals(method) || !MethodCallUtils.isApplicable(method, PsiSubstitutor.EMPTY, types)) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private static PsiExpression getContainingExpression(@NotNull PsiElement expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor.getContainingExpression must not be null");
            }
            PsiElement parent = expression.getParent();
            if (parent == null) {
                return null;
            }
            if (!(parent instanceof PsiExpression) && !(parent instanceof PsiExpressionList)) {
                return null;
            }
            if (parent instanceof PsiParenthesizedExpression || parent instanceof PsiExpressionList) {
                return UnnecessaryUnboxingVisitor.getContainingExpression(parent);
            }
            return (PsiExpression)parent;
        }
    }

    private static class UnnecessaryUnboxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryUnboxingFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unboxing.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/UnnecessaryUnboxingInspection$UnnecessaryUnboxingFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression referenceExpression;
            PsiElement element;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression strippedQualifier = ParenthesesUtils.stripParentheses(qualifier);
            if (strippedQualifier == null) {
                return;
            }
            if (strippedQualifier instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)strippedQualifier).resolve()) instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String classname = containingClass.getQualifiedName();
                if ("java.lang.Boolean".equals(classname)) {
                    String name = field.getName();
                    if ("TRUE".equals(name)) {
                        UnnecessaryUnboxingFix.replaceExpression((PsiExpression)methodCall, "true");
                        return;
                    }
                    if ("FALSE".equals(name)) {
                        UnnecessaryUnboxingFix.replaceExpression((PsiExpression)methodCall, "false");
                        return;
                    }
                }
            }
            String strippedQualifierText = strippedQualifier.getText();
            UnnecessaryUnboxingFix.replaceExpression((PsiExpression)methodCall, strippedQualifierText);
        }
    }
}

