/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CloneUtils;
import org.jetbrains.annotations.NotNull;

public class CloneDeclaresCloneNotSupportedInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CloneDoesntDeclareCloneNotSupportedException" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection.getID must not return null");
        }
        return "CloneDoesntDeclareCloneNotSupportedException";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CloneDeclaresCloneNotSupportedInspectionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneDeclaresCloneNotSupportedExceptionVisitor();
    }

    private static class CloneDeclaresCloneNotSupportedExceptionVisitor
    extends BaseInspectionVisitor {
        private CloneDeclaresCloneNotSupportedExceptionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedExceptionVisitor.visitMethod must not be null");
            }
            if (!CloneUtils.isClone(method)) {
                return;
            }
            if (method.hasModifierProperty("final")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            if (CloneDeclaresCloneNotSupportedExceptionVisitor.hasThrowsCloneNotSupportedException(method)) {
                return;
            }
            PsiMethod[] superMethods = method.findSuperMethods();
            if (superMethods.length < 1) {
                return;
            }
            if (!CloneDeclaresCloneNotSupportedExceptionVisitor.hasThrowsCloneNotSupportedException(superMethods[0])) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        public static boolean hasThrowsCloneNotSupportedException(@NotNull PsiMethod method) {
            PsiClassType[] thrownTypes;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedExceptionVisitor.hasThrowsCloneNotSupportedException must not be null");
            }
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiClassType thrownType : thrownTypes = throwsList.getReferencedTypes()) {
                if (!thrownType.equalsToText("java.lang.CloneNotSupportedException")) continue;
                return true;
            }
            return false;
        }
    }

    private static class CloneDeclaresCloneNotSupportedInspectionFix
    extends InspectionGadgetsFix {
        private CloneDeclaresCloneNotSupportedInspectionFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.declare.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedInspectionFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodNameIdentifier.getParent();
            PsiUtil.addException((PsiMethod)method, (String)"java.lang.CloneNotSupportedException");
        }
    }
}

