/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiType;
import com.siyeh.ig.bugs.Validator;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FormatDecode {
    private static final String FORMAT_SPECIFIER = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final Validator ALL_VALIDATOR = new AllValidator();
    private static final Validator DATE_VALIDATOR = new DateValidator();
    private static final Validator CHAR_VALIDATOR = new CharValidator();
    private static final Validator INT_VALIDATOR = new IntValidator();
    private static final Validator FLOAT_VALIDATOR = new FloatValidator();

    private FormatDecode() {
    }

    public static Validator[] decode(String formatString, int argumentCount) {
        ArrayList<Validator> parameters = new ArrayList<Validator>();
        Matcher matcher = fsPattern.matcher(formatString);
        int implicit = 0;
        int pos = 0;
        int i = 0;
        while (matcher.find(i)) {
            String posSpec = matcher.group(1);
            String flags = matcher.group(2);
            String dateSpec = matcher.group(5);
            String spec = matcher.group(6);
            if (!"n".equals(spec) && !"%".equals(spec)) {
                Validator allowed;
                if (posSpec != null) {
                    String num = posSpec.substring(0, posSpec.length() - 1);
                    pos = Integer.parseInt(num) - 1;
                } else if (flags == null || flags.indexOf(60) < 0) {
                    pos = implicit++;
                }
                if (dateSpec != null) {
                    allowed = DATE_VALIDATOR;
                } else {
                    switch (Character.toLowerCase(spec.charAt(0))) {
                        case 'b': 
                        case 'h': 
                        case 's': {
                            allowed = ALL_VALIDATOR;
                            break;
                        }
                        case 'c': {
                            allowed = CHAR_VALIDATOR;
                            break;
                        }
                        case 'd': 
                        case 'o': 
                        case 'x': {
                            allowed = INT_VALIDATOR;
                            break;
                        }
                        case 'a': 
                        case 'e': 
                        case 'f': 
                        case 'g': {
                            allowed = FLOAT_VALIDATOR;
                            break;
                        }
                        default: {
                            throw new UnknownFormatException(matcher.group());
                        }
                    }
                }
                FormatDecode.argAt(allowed, pos, parameters, argumentCount);
            }
            i = matcher.end();
        }
        return parameters.toArray(new Validator[parameters.size()]);
    }

    private static void argAt(Validator val, int pos, ArrayList<Validator> parameters, int argumentCount) {
        if (pos < parameters.size()) {
            Validator old = parameters.get(pos);
            if (old == ALL_VALIDATOR) {
                parameters.set(pos, val);
            } else if (val != ALL_VALIDATOR && val != old) {
                throw new DuplicateFormatFlagsException("requires both " + old.type() + " and " + val.type());
            }
        } else {
            while (pos > parameters.size() && argumentCount > parameters.size()) {
                parameters.add(ALL_VALIDATOR);
            }
            parameters.add(val);
        }
    }

    private static class FloatValidator
    implements Validator {
        private FloatValidator() {
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiType.DOUBLE.equals(type) || "java.lang.Double".equals(text) || PsiType.FLOAT.equals(type) || "java.lang.Float".equals(text) || "java.math.BigDecimal".equals(text);
        }

        @Override
        public String type() {
            return "floating point";
        }
    }

    private static class IntValidator
    implements Validator {
        private IntValidator() {
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiType.INT.equals(type) || "java.lang.Integer".equals(text) || PsiType.LONG.equals(type) || "java.lang.Long".equals(text) || PsiType.SHORT.equals(type) || "java.lang.Short".equals(text) || PsiType.BYTE.equals(type) || "java.lang.Byte".equals(text) || "java.math.BigInteger".equals(text);
        }

        @Override
        public String type() {
            return "integer type";
        }
    }

    private static class CharValidator
    implements Validator {
        private CharValidator() {
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiType.CHAR.equals(type) || "java.lang.Character".equals(text);
        }

        @Override
        public String type() {
            return "char";
        }
    }

    private static class DateValidator
    implements Validator {
        private DateValidator() {
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiType.LONG.equals(type) || "java.lang.Long".equals(text) || "java.util.Date".equals(text) || "java.util.Calendar".equals(text);
        }

        @Override
        public String type() {
            return "Date/Time";
        }
    }

    private static class AllValidator
    implements Validator {
        private AllValidator() {
        }

        @Override
        public boolean valid(PsiType type) {
            return true;
        }

        @Override
        public String type() {
            return "any";
        }
    }

    public static class DuplicateFormatFlagsException
    extends RuntimeException {
        public DuplicateFormatFlagsException(String message) {
            super(message);
        }
    }

    public static class UnknownFormatException
    extends RuntimeException {
        public UnknownFormatException(String message) {
            super(message);
        }
    }
}

