/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TObjectFloatHashMap;
import gnu.trove.TObjectFloatIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectFloatHashMapDecorator<V>
extends AbstractMap<V, Float>
implements Map<V, Float> {
    protected final TObjectFloatHashMap<V> _map;

    public TObjectFloatHashMapDecorator(TObjectFloatHashMap<V> map) {
        this._map = map;
    }

    @Override
    public Float put(V key, Float value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (val instanceof Float) {
                    V k = this.unwrapKey(key);
                    float v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        V k = this.unwrapKey(key);
        float v = this._map.get(k);
        if (v == 0.0f) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Float remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<V, Float>> entrySet() {
        return new AbstractSet<Map.Entry<V, Float>>(){

            @Override
            public int size() {
                return TObjectFloatHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TObjectFloatHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TObjectFloatHashMapDecorator.this.containsKey(k) && TObjectFloatHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<V, Float>> iterator() {
                return new Iterator<Map.Entry<V, Float>>(){
                    private final TObjectFloatIterator<V> it;
                    {
                        this.it = TObjectFloatHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<V, Float> next() {
                        this.it.advance();
                        final Object key = TObjectFloatHashMapDecorator.this.wrapKey(this.it.key());
                        final Float v = TObjectFloatHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<V, Float>(){
                            private Float val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public V getKey() {
                                return key;
                            }

                            @Override
                            public Float getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Float setValue(Float value) {
                                this.val = value;
                                return TObjectFloatHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Float o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<V, Float>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TObjectFloatHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends V, ? extends Float> map) {
        Iterator<Map.Entry<V, Float>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<V, Float> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected final V wrapKey(Object o) {
        return (V)o;
    }

    protected final V unwrapKey(Object key) {
        return (V)key;
    }

    protected Float wrapValue(float k) {
        return new Float(k);
    }

    protected float unwrapValue(Object value) {
        return ((Float)value).floatValue();
    }
}

