/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.JUnit4OutputObjectRegistry;
import com.intellij.junit4.JUnit4ReflectionUtil;
import com.intellij.junit4.JUnit4TestResultsSender;
import com.intellij.junit4.JUnit4TestRunnerUtil;
import com.intellij.rt.execution.junit.DeafStream;
import com.intellij.rt.execution.junit.IDEAJUnitListener;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.Packet;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import junit.textui.ResultPrinter;
import org.junit.internal.requests.ClassRequest;
import org.junit.internal.requests.FilterRequest;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;

public class JUnit4IdeaTestRunner
implements IdeaTestRunner {
    private RunListener myTestsListener;
    private OutputObjectRegistry myRegistry;
    static /* synthetic */ Class class$org$junit$internal$requests$FilterRequest;
    static /* synthetic */ Class class$org$junit$internal$requests$ClassRequest;

    private static void sendNode(Description test, Packet packet) {
        ArrayList children = test.getChildren();
        packet.addObject((Object)test).addLong((long)children.size());
        for (int i = 0; i < children.size(); ++i) {
            JUnit4IdeaTestRunner.sendNode((Description)children.get(i), packet);
        }
    }

    public static void sendTree(OutputObjectRegistry registry, Description suite) {
        Packet packet = registry.createPacket();
        packet.addString("T");
        JUnit4IdeaTestRunner.sendNode(suite, packet);
        packet.addString("\n");
        packet.send();
    }

    public int startRunnerWithArgs(String[] args, ArrayList listeners) {
        try {
            JUnitCore runner = new JUnitCore();
            Request request = JUnit4TestRunnerUtil.buildRequest(args);
            Runner testRunner = request.getRunner();
            try {
                Description description = testRunner.getDescription();
                if (request instanceof ClassRequest) {
                    description = JUnit4IdeaTestRunner.getSuiteMethodDescription(request, description);
                } else if (request instanceof FilterRequest) {
                    description = JUnit4IdeaTestRunner.getFilteredDescription(request, description);
                }
                JUnit4IdeaTestRunner.sendTree(this.myRegistry, description);
            }
            catch (Exception e) {
                System.err.println("Internal Error occured.");
                e.printStackTrace(System.err);
            }
            runner.addListener(this.myTestsListener);
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                final IDEAJUnitListener junitListener = (IDEAJUnitListener)Class.forName((String)iterator.next()).newInstance();
                runner.addListener(new RunListener(){

                    public void testStarted(Description description) throws Exception {
                        junitListener.testStarted(JUnit4ReflectionUtil.getClassName(description), JUnit4ReflectionUtil.getMethodName(description));
                    }

                    public void testFinished(Description description) throws Exception {
                        junitListener.testFinished(JUnit4ReflectionUtil.getClassName(description), JUnit4ReflectionUtil.getMethodName(description));
                    }
                });
            }
            long startTime = System.currentTimeMillis();
            Result result = runner.run(testRunner);
            long endTime = System.currentTimeMillis();
            long runTime = endTime - startTime;
            new TimeSender().printHeader(runTime);
            if (!result.wasSuccessful()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -2;
        }
    }

    private static Description getFilteredDescription(Request request, Description description) throws NoSuchFieldException, IllegalAccessException {
        Field field = (class$org$junit$internal$requests$FilterRequest == null ? (class$org$junit$internal$requests$FilterRequest = JUnit4IdeaTestRunner.class$("org.junit.internal.requests.FilterRequest")) : class$org$junit$internal$requests$FilterRequest).getDeclaredField("fFilter");
        field.setAccessible(true);
        Filter filter = (Filter)field.get(request);
        String filterDescription = filter.describe();
        try {
            Description failedTestsDescription = Description.createSuiteDescription((String)filterDescription, null);
            Iterator iterator = description.getChildren().iterator();
            while (iterator.hasNext()) {
                Description childDescription = (Description)iterator.next();
                if (!filter.shouldRun(childDescription)) continue;
                failedTestsDescription.addChild(childDescription);
            }
            description = failedTestsDescription;
            if (!failedTestsDescription.isTest() && failedTestsDescription.testCount() == 1 && filterDescription.startsWith("Method")) {
                description = (Description)failedTestsDescription.getChildren().get(0);
            }
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        return description;
    }

    private static Description getSuiteMethodDescription(Request request, Description description) throws NoSuchFieldException, IllegalAccessException {
        Field field = (class$org$junit$internal$requests$ClassRequest == null ? (class$org$junit$internal$requests$ClassRequest = JUnit4IdeaTestRunner.class$("org.junit.internal.requests.ClassRequest")) : class$org$junit$internal$requests$ClassRequest).getDeclaredField("fTestClass");
        field.setAccessible(true);
        Description methodDescription = Description.createSuiteDescription((Class)((Class)field.get(request)));
        Iterator iterator = description.getChildren().iterator();
        while (iterator.hasNext()) {
            methodDescription.addChild((Description)iterator.next());
        }
        description = methodDescription;
        return description;
    }

    public void setStreams(SegmentedOutputStream segmentedOut, SegmentedOutputStream segmentedErr) {
        this.myRegistry = new JUnit4OutputObjectRegistry((PacketProcessor)segmentedOut, (PacketProcessor)segmentedErr);
        this.myTestsListener = new JUnit4TestResultsSender(this.myRegistry, (PacketProcessor)segmentedErr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TimeSender
    extends ResultPrinter {
        public TimeSender() {
            super(DeafStream.DEAF_PRINT_STREAM);
        }

        protected void printHeader(long runTime) {
            JUnit4IdeaTestRunner.this.myRegistry.createPacket().addString("D").addLong(runTime).send();
        }
    }
}

