/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntCall;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.psi.impl.AntTaskImpl;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.psi.PsiLock;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntCallImpl
extends AntTaskImpl
implements AntCall {
    private AntTarget[] myDependsTargets = null;
    private AntProperty[] myParams = null;

    public AntCallImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntCallImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntCall(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("AntCall to ");
            AntTarget target = this.getTarget();
            builder.append(target == null ? "null" : target.toString());
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AntTarget getTarget() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            AntTarget result;
            String target = this.getSourceElement().getAttributeValue("target");
            AntTarget antTarget = result = target == null ? null : this.getAntProject().getTarget(target);
            if (result != null) {
                result.setDependsTargets(this.getDependsTargets());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public AntProperty[] getParams() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myParams == null) {
            ArrayList<AntProperty> properties = new ArrayList<AntProperty>();
            for (AntElement element : this.getChildren()) {
                if (!(element instanceof AntProperty)) continue;
                properties.add((AntProperty)element);
            }
            this.myParams = properties.toArray(new AntProperty[properties.size()]);
        }
        // MONITOREXIT : object
        if (this.myParams != null) return this.myParams;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntCallImpl.getParams must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.myDependsTargets = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AntTarget[] getDependsTargets() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myDependsTargets == null) {
            ArrayList<AntTarget> targets = new ArrayList<AntTarget>();
            for (AntElement element : this.getChildren()) {
                if (!(element instanceof AntTarget)) continue;
                targets.add((AntTarget)element);
            }
            this.myDependsTargets = targets.toArray(new AntTarget[targets.size()]);
        }
        // MONITOREXIT : object
        if (this.myDependsTargets != null) return this.myDependsTargets;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntCallImpl.getDependsTargets must not return null");
    }
}

